"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupDetectorRoutes = setupDetectorRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupDetectorRoutes(services, router) {
  const {
    detectorsService
  } = services;
  router.post({
    path: _constants.API.DETECTORS_BASE,
    validate: {
      body: _configSchema.schema.any()
    }
  }, detectorsService.createDetector);
  router.get({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      })
    }
  }, detectorsService.getDetector);
  router.post({
    path: `${_constants.API.SEARCH_DETECTORS}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, detectorsService.searchDetectors);
  router.put({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, detectorsService.updateDetector);
  router.delete({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, detectorsService.deleteDetector);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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