"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateModelSearchQuery = void 0;

var _query = require("./query");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const generateModelSearchQuery = ({
  states,
  nameOrId
}) => ({
  bool: {
    must: [...(states ? [(0, _query.generateTermQuery)('model_state', states)] : []), ...(nameOrId ? [{
      bool: {
        should: [{
          wildcard: {
            'name.keyword': {
              value: `*${nameOrId}*`,
              case_insensitive: true
            }
          }
        }, (0, _query.generateTermQuery)('_id', nameOrId)]
      }
    }] : [])],
    must_not: {
      exists: {
        field: 'chunk_number'
      }
    }
  }
});

exports.generateModelSearchQuery = generateModelSearchQuery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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