/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.fill.JRTemplateElement;

public class JRTemplateText
extends JRTemplateElement {
    private static final long serialVersionUID = 10001L;
    private byte horizontalAlignment = 1;
    private byte verticalAlignment = 1;
    private byte rotation = 0;
    private byte lineSpacing = 0;
    private boolean isStyledText = false;
    private byte hyperlinkType = 1;
    private byte hyperlinkTarget = 1;
    private JRBox box = null;
    private JRFont font = null;

    protected JRTemplateText(JRStaticText staticText, JRFont font) {
        this.setStaticText(staticText);
        this.font = font;
    }

    protected JRTemplateText(JRTextField textField, JRFont font) {
        this.setTextField(textField);
        this.font = font;
    }

    protected void setStaticText(JRStaticText staticText) {
        this.setTextElement(staticText);
    }

    protected void setTextField(JRTextField textField) {
        this.setTextElement(textField);
        this.hyperlinkType = textField.getHyperlinkType();
        this.hyperlinkTarget = textField.getHyperlinkTarget();
    }

    protected void setTextElement(JRTextElement textElement) {
        super.setElement(textElement);
        this.box = textElement.getBox();
        this.horizontalAlignment = textElement.getHorizontalAlignment();
        this.verticalAlignment = textElement.getVerticalAlignment();
        this.rotation = textElement.getRotation();
        this.lineSpacing = textElement.getLineSpacing();
        this.isStyledText = textElement.isStyledText();
    }

    public byte getTextAlignment() {
        return this.horizontalAlignment;
    }

    public byte getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public byte getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public byte getRotation() {
        return this.rotation;
    }

    public byte getLineSpacing() {
        return this.lineSpacing;
    }

    public boolean isStyledText() {
        return this.isStyledText;
    }

    public JRBox getBox() {
        return this.box;
    }

    public JRFont getFont() {
        return this.font;
    }

    public byte getHyperlinkType() {
        return this.hyperlinkType;
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }
}

