/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog.calendar;

import com.projectlibre1.contrib.calendar.ContribIntervals;
import com.projectlibre1.dialog.calendar.CalendarInterval;
import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.util.DateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swing.calendar.DateSpan;

public class Intervals
extends TreeSet
implements HasStartAndEnd {
    public Intervals(ContribIntervals contribIntervals) {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
                HasStartAndEnd hasStartAndEnd2 = (HasStartAndEnd)object2;
                if (hasStartAndEnd.getStart() < hasStartAndEnd2.getStart() || hasStartAndEnd.getStart() == hasStartAndEnd2.getStart() && hasStartAndEnd.getEnd() < hasStartAndEnd2.getEnd()) {
                    return -1;
                }
                if (hasStartAndEnd.getStart() > hasStartAndEnd2.getStart() || hasStartAndEnd.getStart() == hasStartAndEnd2.getStart() && hasStartAndEnd.getEnd() > hasStartAndEnd2.getEnd()) {
                    return 1;
                }
                return 0;
            }
        });
        if (contribIntervals != null) {
            for (DateSpan dateSpan : contribIntervals) {
                if (!super.add(new CalendarInterval(dateSpan.getStart(), dateSpan.getEnd()))) continue;
            }
        }
    }

    protected HasStartAndEnd createInterval(long l, long l2) {
        return new CalendarInterval(l, l2);
    }

    protected HasStartAndEnd mergeIntervals(HasStartAndEnd hasStartAndEnd, HasStartAndEnd hasStartAndEnd2) {
        return new CalendarInterval(Math.min(hasStartAndEnd.getStart(), hasStartAndEnd2.getStart()), Math.max(hasStartAndEnd.getEnd(), hasStartAndEnd2.getEnd()));
    }

    @Override
    public boolean add(Object object) {
        HasStartAndEnd hasStartAndEnd;
        HasStartAndEnd hasStartAndEnd2 = (HasStartAndEnd)object;
        SortedSet<Object> sortedSet = this.headSet(object);
        if (sortedSet.size() > 0 && (hasStartAndEnd = (HasStartAndEnd)sortedSet.last()).getEnd() >= hasStartAndEnd2.getStart()) {
            hasStartAndEnd2 = this.mergeIntervals(hasStartAndEnd2, hasStartAndEnd);
        }
        if ((sortedSet = this.tailSet(object)).size() > 0) {
            hasStartAndEnd = (HasStartAndEnd)sortedSet.first();
            if (hasStartAndEnd2.getEnd() >= hasStartAndEnd.getStart()) {
                hasStartAndEnd2 = this.mergeIntervals(hasStartAndEnd2, hasStartAndEnd);
            }
        }
        return super.add(hasStartAndEnd2);
    }

    @Override
    public boolean addAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!super.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public long getEnd() {
        return this.size() == 0 ? -1L : ((HasStartAndEnd)this.last()).getEnd();
    }

    @Override
    public long getStart() {
        return this.size() == 0 ? -1L : ((HasStartAndEnd)this.first()).getStart();
    }

    public boolean containsDate(long l) {
        for (HasStartAndEnd hasStartAndEnd : this) {
            if (hasStartAndEnd.getStart() > l || l > hasStartAndEnd.getEnd()) continue;
            return true;
        }
        return false;
    }

    void eliminateWeekdayDuplicates(boolean[] blArray) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)iterator.next();
            gregorianCalendar.setTimeInMillis(hasStartAndEnd.getStart());
            int n = gregorianCalendar.get(7) - 1;
            for (int i = 0; i < 7; ++i) {
                if (!blArray[i] || i != n) continue;
                iterator.remove();
            }
        }
    }
}

