/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.CharsetHelper;

public enum CodePage {
    ANSI("ANSI", CharsetHelper.CP1252),
    MAC("MAC", CharsetHelper.MAC_ROMAN),
    LATIN("850", CharsetHelper.CP850),
    US("437", CharsetHelper.CP437),
    ZH("ZH", CharsetHelper.GB2312),
    RU("RU", CharsetHelper.CP1251);

    private String m_value;
    private Charset m_charset;
    private static final Map<String, CodePage> NAME_MAP;

    private CodePage(String string2, Charset charset) {
        this.m_value = string2;
        this.m_charset = charset;
    }

    public static CodePage getInstance(String string) {
        CodePage codePage = NAME_MAP.get(string);
        if (codePage == null) {
            codePage = ANSI;
        }
        return codePage;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public String toString() {
        return this.m_value;
    }

    static {
        NAME_MAP = new HashMap<String, CodePage>();
        for (CodePage codePage : EnumSet.allOf(CodePage.class)) {
            NAME_MAP.put(codePage.m_value, codePage);
        }
    }
}

