/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class TimeColumn
extends AbstractColumn {
    TimeColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 48;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        FixedSizeItemsBlock fixedSizeItemsBlock = new FixedSizeItemsBlock().read(byArray, n);
        n = fixedSizeItemsBlock.getOffset();
        Calendar calendar = Calendar.getInstance();
        byte[][] byArray2 = fixedSizeItemsBlock.getData();
        this.m_data = new Date[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i].length <= 1) continue;
            int n2 = FastTrackUtility.getShort(byArray2[i], 0);
            calendar.set(11, n2 / 60);
            calendar.set(12, n2 % 60);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.m_data[i] = calendar.getTime();
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            printWriter.println("    " + simpleDateFormat.format((Date)object));
        }
        printWriter.println("  ]");
    }
}

