/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public class DayDatatypeValidator
extends DateTimeValidator {
    private static final int DAY_SIZE = 5;

    public DayDatatypeValidator() throws InvalidDatatypeFacetException {
    }

    public DayDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append('-');
        this.message.append(nArray[2]);
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-' || this.fBuffer.charAt(2) != '-') {
            throw new SchemaDateTimeException("Error in day parsing");
        }
        nArray[0] = 2000;
        nArray[1] = 1;
        nArray[2] = this.parseInt(this.fStart + 3, this.fStart + 5);
        if (this.fEnd > 5) {
            int n = this.findUTCSign(5, this.fEnd);
            if (n < 0) {
                throw new SchemaDateTimeException("Error in day parsing");
            }
            this.getTimeZone(nArray, n);
        }
        this.validateDateTime(nArray);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray);
        }
        return nArray;
    }
}

