/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.ColourAdapter;
import jalview.DrawableSequence;
import jalview.FastaFile;
import jalview.FormatAdapter;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class ClustalwCGI
extends CGI {
    Sequence[] sequence;

    public ClustalwCGI(String string, int n, String string2, Sequence[] sequenceArray, PrintStream printStream) {
        super(string, n, string2, printStream);
        this.sequence = sequenceArray;
        this.variables = this.makeVariables();
    }

    public Hashtable makeVariables() {
        String string = FastaFile.print(this.sequence, 72);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("sequence", string);
        hashtable.put("newseq", "poggy");
        return hashtable;
    }

    public void readInput(DataInputStream dataInputStream) {
        String string = "";
        boolean bl = false;
        String string2 = "";
        try {
            while ((string = dataInputStream.readLine()) != null) {
                if (string.indexOf("CLUSTAL") == 0) {
                    bl = true;
                }
                if (bl) {
                    string2 = String.valueOf(string2) + string + "\n";
                    continue;
                }
                this.statout.println(string);
            }
            this.statout.print(string2);
            DrawableSequence[] drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read("CLUSTAL", string2));
            AlignFrame alignFrame = new AlignFrame((Object)"Null", drawableSequenceArray);
            alignFrame.ap.seqPanel.align.percentIdentity();
            alignFrame.cons = alignFrame.ap.seqPanel.align.cons;
            alignFrame.ap.seqPanel.align.setColourScheme(ColourAdapter.get(2));
            alignFrame.resize(700, 500);
            alignFrame.show();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            FastaFile fastaFile = new FastaFile("hth2.fa", "File");
            Sequence[] sequenceArray = new Sequence[fastaFile.seqs.size()];
            int n = 0;
            while (n < fastaFile.seqs.size()) {
                sequenceArray[n] = (Sequence)fastaFile.seqs.elementAt(n);
                ++n;
            }
            ClustalwCGI clustalwCGI = new ClustalwCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runclustal", sequenceArray, System.out);
            clustalwCGI.run();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception " + iOException);
            return;
        }
    }
}

