/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.touch;

import java.io.IOException;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;

@CommandDefinition(name="touch", description="create and change file timestamps")
public class Touch
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=97, name="access time", hasValue=false, description="change only the access time")
    private boolean changeOnlyAccessTime;
    @Option(shortName=109, name="modification time", hasValue=false, description="change only the modification time")
    private boolean changeOnlyModificationTime;
    @Option(shortName=99, name="no create", hasValue=false, description="do not create any files")
    private boolean noCreate;
    @Arguments
    private List<Resource> args;

    @Override
    public CommandResult execute(CommandInvocation ci) {
        if (this.help || this.args == null || this.args.isEmpty()) {
            ci.getShell().writeln(ci.getHelpInfo("touch"));
            return CommandResult.SUCCESS;
        }
        Resource currentDir = ci.getConfiguration().getAeshContext().getCurrentWorkingDirectory();
        for (Resource r : this.args) {
            Resource res = r.resolve(currentDir).get(0);
            try {
                this.touch(res, ci);
            }
            catch (IOException e) {
                ci.println("failed to touch: " + e.getMessage());
            }
        }
        return CommandResult.SUCCESS;
    }

    private void touch(Resource r, CommandInvocation ci) throws IOException {
        if (r.exists()) {
            if (this.changeOnlyAccessTime) {
                r.setLastAccessed(System.currentTimeMillis());
            }
            if (this.changeOnlyModificationTime) {
                r.setLastModified(System.currentTimeMillis());
            }
        } else if (!this.noCreate) {
            this.create(r, ci);
        }
    }

    private void create(Resource r, CommandInvocation ci) throws IOException {
        r.resolve(ci.getConfiguration().getAeshContext().getCurrentWorkingDirectory()).get(0).write(false);
    }
}

