/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.state.ProvisionedPackage;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.ProvisionedConfigBuilder;
import org.jboss.galleon.xml.ProvisionedConfigXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class ProvisionedStateXmlParser30
implements PlugableXmlParser<ProvisionedState.Builder> {
    public static final String NAMESPACE_3_0 = "urn:jboss:galleon:provisioned-state:3.0";
    public static final QName ROOT_3_0 = new QName("urn:jboss:galleon:provisioned-state:3.0", Element.INSTALLATION.getLocalName());

    ProvisionedStateXmlParser30() {
    }

    @Override
    public QName getRoot() {
        return ROOT_3_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisionedState.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FEATURE_PACK: {
                            builder.addFeaturePack(this.readFeaturePack(reader));
                            continue block8;
                        }
                        case CONFIG: {
                            ProvisionedConfigBuilder configBuilder = ProvisionedConfigBuilder.builder();
                            ProvisionedConfigXmlParser30.read(reader, configBuilder);
                            builder.addConfig(configBuilder.build());
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ProvisionedFeaturePack readFeaturePack(XMLExtendedStreamReader reader) throws XMLStreamException {
        ProvisionedFeaturePack.Builder fpBuilder = ProvisionedFeaturePack.builder(ProvisionedStateXmlParser30.parseSource(reader).getFPID());
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return fpBuilder.build();
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGES: {
                            this.readPackageList(reader, fpBuilder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static FeaturePackLocation parseSource(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        FeaturePackLocation fps = null;
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case LOCATION: {
                    try {
                        fps = FeaturePackLocation.fromString(reader.getAttributeValue(i));
                        continue block5;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XMLStreamException("Failed to parse feature-pack location", e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (fps == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.LOCATION));
        }
        return fps;
    }

    private void readPackageList(XMLExtendedStreamReader reader, ProvisionedFeaturePack.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGE: {
                            builder.addPackage(this.readPackage(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ProvisionedPackage readPackage(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        return ProvisionedPackage.newInstance(name);
    }

    static enum Attribute implements XmlNameProvider
    {
        ID("id"),
        LOCATION("location"),
        MODEL("model"),
        NAME("name"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<QName, Attribute>(6);
            attributes.put(new QName(Attribute.ID.name), ID);
            attributes.put(new QName(Attribute.LOCATION.name), LOCATION);
            attributes.put(new QName(Attribute.MODEL.name), MODEL);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        FEATURE("feature"),
        FEATURE_PACK("feature-pack"),
        INSTALLATION("installation"),
        LAYER("layer"),
        LAYERS("layers"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PARAM("param"),
        PROP("prop"),
        PROPS("props"),
        SPEC("spec"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioned-state:3.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisionedStateXmlParser30.NAMESPACE_3_0;
        }

        public String toString() {
            return this.name;
        }

        static {
            elements = new HashMap<QName, Element>(13);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.CONFIG.name), CONFIG);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.FEATURE.name), FEATURE);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.FEATURE_PACK.name), FEATURE_PACK);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.INSTALLATION.name), INSTALLATION);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.LAYER.name), LAYER);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.LAYERS.name), LAYERS);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.PACKAGE.name), PACKAGE);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.PACKAGES.name), PACKAGES);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.PARAM.name), PARAM);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.PROP.name), PROP);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.PROPS.name), PROPS);
            elements.put(new QName(ProvisionedStateXmlParser30.NAMESPACE_3_0, Element.SPEC.name), SPEC);
            elements.put(null, UNKNOWN);
        }
    }
}

