/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.DemoInstVarsAccessorImplBase;
import java2d.DemoPanel;
import java2d.GlobalControls;
import java2d.J2Ddemo;
import java2d.Tools;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DemoGroup
extends JPanel
implements ChangeListener,
ActionListener {
    private final DemoInstVarsAccessor demoInstVars;
    public int columns = 2;
    private static final Font font = new Font("Serif", 0, 10);
    private final EmptyBorder emptyB = new EmptyBorder(5, 5, 5, 5);
    private final BevelBorder bevelB = new BevelBorder(1);
    private String groupName;
    public JPanel[] clonePanels;
    public JTabbedPane tabbedPane;
    private int index;

    public DemoGroup(String name, DemoInstVarsAccessor demoInstVars) {
        this.groupName = name;
        this.demoInstVars = demoInstVars;
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridLayout(0, 2));
        p.setBorder(new CompoundBorder(this.emptyB, this.bevelB));
        int ind = -1;
        while (!name.equals(J2Ddemo.demos[++ind][0])) {
        }
        String[] demos = J2Ddemo.demos[ind];
        int numDemos = demos.length - 1;
        if (numDemos % 2 == 1) {
            p.setLayout(new GridBagLayout());
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DemoGroup.this.mouseClicked(e.getComponent());
            }
        };
        for (int i = 1; i <= numDemos; ++i) {
            DemoPanel dp = new DemoPanel("java2d.demos." + name + "." + demos[i], demoInstVars);
            dp.setDemoBorder(p);
            if (dp.surface != null) {
                dp.surface.addMouseListener(mouseListener);
                dp.surface.setMonitor(demoInstVars.getPerformanceMonitor() != null);
            }
            if (p.getLayout() instanceof GridBagLayout) {
                int x = p.getComponentCount() % 2;
                int y = p.getComponentCount() / 2;
                int w = i == numDemos ? 2 : 1;
                J2Ddemo.addToGridBag(p, dp, x, y, w, 1, 1.0, 1.0);
                continue;
            }
            p.add(dp);
        }
        this.add(p);
    }

    public void mouseClicked(Component component) {
        String className = component.toString();
        if (this.tabbedPane == null) {
            this.shutDown(this.getPanel());
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(new CompoundBorder(this.emptyB, this.bevelB));
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setFont(font);
            JPanel tmpP = (JPanel)this.getComponent(0);
            this.tabbedPane.addTab(this.groupName, tmpP);
            this.clonePanels = new JPanel[tmpP.getComponentCount()];
            for (int i = 0; i < this.clonePanels.length; ++i) {
                this.clonePanels[i] = new JPanel(new BorderLayout());
                DemoPanel dp = (DemoPanel)tmpP.getComponent(i);
                DemoPanel c = new DemoPanel(dp.className, this.demoInstVars);
                c.setDemoBorder(this.clonePanels[i]);
                if (c.surface != null) {
                    c.surface.setMonitor(this.demoInstVars.getPerformanceMonitor() != null);
                    Image cloneImg = DemoImages.getImage("clone.gif", this);
                    c.tools.cloneB = c.tools.addTool(cloneImg, "Clone the Surface", (ActionListener)this);
                    Dimension d = c.tools.toolbar.getPreferredSize();
                    c.tools.toolbar.setPreferredSize(new Dimension(d.width + 27, d.height));
                    if (this.demoInstVars.getBackgroundColor() != null) {
                        c.surface.setBackground(this.demoInstVars.getBackgroundColor());
                    }
                }
                this.clonePanels[i].add(c);
                String s = dp.className.substring(dp.className.indexOf(46) + 1);
                this.tabbedPane.addTab(s, this.clonePanels[i]);
            }
            p.add(this.tabbedPane);
            this.remove(tmpP);
            this.add(p);
            this.tabbedPane.addChangeListener(this);
            this.revalidate();
        }
        className = className.substring(0, className.indexOf(91));
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String s1 = className.substring(className.indexOf(46) + 1);
            if (!this.tabbedPane.getTitleAt(i).equals(s1)) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        if (b.getToolTipText().startsWith("Clone")) {
            this.cloneDemo();
        } else {
            this.removeClone(b.getParent().getParent().getParent().getParent());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.shutDown((JPanel)this.tabbedPane.getComponentAt(this.index));
        this.index = this.tabbedPane.getSelectedIndex();
        this.setup(false);
    }

    public JPanel getPanel() {
        if (this.tabbedPane != null) {
            return (JPanel)this.tabbedPane.getSelectedComponent();
        }
        return (JPanel)this.getComponent(0);
    }

    public void setup(boolean issueRepaint) {
        JPanel p = this.getPanel();
        if (this.demoInstVars.getPerformanceMonitor() != null) {
            this.demoInstVars.getPerformanceMonitor().surf.setPanel(p);
            this.demoInstVars.getPerformanceMonitor().surf.setSurfaceState();
        }
        GlobalControls c = this.demoInstVars.getControls();
        for (int i = 0; i < p.getComponentCount(); ++i) {
            DemoPanel dp = (DemoPanel)p.getComponent(i);
            if (dp.surface != null && c != null) {
                Tools t = dp.tools;
                t.setVisible(this.isValid());
                t.issueRepaint = issueRepaint;
                JToggleButton[] b = new JToggleButton[]{t.toggleB, t.aliasB, t.renderB, t.textureB, t.compositeB};
                JCheckBox[] cb = new JCheckBox[]{c.toolBarCB, c.aliasCB, c.renderCB, c.textureCB, c.compositeCB};
                for (int j = 0; j < b.length; ++j) {
                    if (c.obj != null && c.obj.equals(cb[j])) {
                        if (b[j].isSelected() == cb[j].isSelected()) continue;
                        b[j].doClick();
                        continue;
                    }
                    if (c.obj != null || b[j].isSelected() == cb[j].isSelected()) continue;
                    b[j].doClick();
                }
                t.setVisible(true);
                if (c.screenCombo.getSelectedIndex() != t.screenCombo.getSelectedIndex()) {
                    t.screenCombo.setSelectedIndex(c.screenCombo.getSelectedIndex());
                }
                if (this.demoInstVars.getVerboseCB().isSelected()) {
                    dp.surface.verbose(c);
                }
                dp.surface.setSleepAmount(c.slider.getValue());
                if (this.demoInstVars.getBackgroundColor() != null) {
                    dp.surface.setBackground(this.demoInstVars.getBackgroundColor());
                }
                t.issueRepaint = true;
            }
            dp.start();
        }
        this.revalidate();
    }

    public void shutDown(JPanel p) {
        for (int i = 0; i < p.getComponentCount(); ++i) {
            ((DemoPanel)p.getComponent(i)).stop();
        }
        System.gc();
    }

    public void cloneDemo() {
        JPanel panel = this.clonePanels[this.tabbedPane.getSelectedIndex() - 1];
        if (panel.getComponentCount() == 1) {
            panel.invalidate();
            panel.setLayout(new GridLayout(0, this.columns, 5, 5));
            panel.revalidate();
        }
        DemoPanel original = (DemoPanel)this.getPanel().getComponent(0);
        DemoPanel clone = new DemoPanel(original.className, this.demoInstVars);
        if (this.columns == 2) {
            clone.setDemoBorder(panel);
        }
        Image removeImg = DemoImages.getImage("remove.gif", this);
        clone.tools.cloneB = clone.tools.addTool(removeImg, "Remove the Surface", (ActionListener)this);
        Dimension d = clone.tools.toolbar.getPreferredSize();
        clone.tools.toolbar.setPreferredSize(new Dimension(d.width + 27, d.height));
        if (this.demoInstVars.getBackgroundColor() != null) {
            clone.surface.setBackground(this.demoInstVars.getBackgroundColor());
        }
        if (this.demoInstVars.getControls() != null && clone.tools.isExpanded != this.demoInstVars.getControls().toolBarCB.isSelected()) {
            clone.tools.toggleB.doClick();
        }
        clone.start();
        clone.surface.setMonitor(this.demoInstVars.getPerformanceMonitor() != null);
        panel.add(clone);
        panel.repaint();
        panel.revalidate();
    }

    public void removeClone(Component theClone) {
        JPanel panel = this.clonePanels[this.tabbedPane.getSelectedIndex() - 1];
        if (panel.getComponentCount() == 2) {
            Component cmp = panel.getComponent(0);
            panel.removeAll();
            panel.setLayout(new BorderLayout());
            panel.revalidate();
            panel.add(cmp);
        } else {
            panel.remove(theClone);
            int cmpCount = panel.getComponentCount();
            for (int j = 1; j < cmpCount; ++j) {
                int top = j + 1 >= 3 ? 0 : 5;
                int left = (j + 1) % 2 == 0 ? 0 : 5;
                EmptyBorder eb = new EmptyBorder(top, left, 5, 5);
                SoftBevelBorder sbb = new SoftBevelBorder(0);
                JPanel p = (JPanel)panel.getComponent(j);
                p.setBorder(new CompoundBorder(eb, sbb));
            }
        }
        panel.repaint();
        panel.revalidate();
    }

    public static void main(String[] args) {
        class DemoInstVarsAccessorImpl
        extends DemoInstVarsAccessorImplBase {
            private volatile JCheckBoxMenuItem ccthreadCB;

            DemoInstVarsAccessorImpl() {
            }

            public void setCcthreadCB(JCheckBoxMenuItem ccthreadCB) {
                this.ccthreadCB = ccthreadCB;
            }

            @Override
            public JCheckBoxMenuItem getCcthreadCB() {
                return this.ccthreadCB;
            }
        }
        DemoInstVarsAccessorImpl demoInstVars = new DemoInstVarsAccessorImpl();
        final DemoGroup group = new DemoGroup(args[0], demoInstVars);
        JFrame f = new JFrame("Java2D(TM) Demo - DemoGroup");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                group.setup(false);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                group.shutDown(group.getPanel());
            }
        });
        f.getContentPane().add("Center", group);
        f.pack();
        int FRAME_WIDTH = 620;
        int FRAME_HEIGHT = 530;
        f.setSize(FRAME_WIDTH, FRAME_HEIGHT);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        for (String arg : args) {
            if (!arg.startsWith("-ccthread")) continue;
            demoInstVars.setCcthreadCB(new JCheckBoxMenuItem("CCThread", true));
        }
        group.setup(false);
    }
}

