/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Composite;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FadeAnim
extends AnimatingControlsSurface {
    private static final TexturePaint texturePaint;
    private static BasicStroke bs;
    private static Font[] fonts;
    private static String[] strings;
    private static String[] imgs;
    private static Paint[] paints;
    private List<ObjectData> objects = new ArrayList<ObjectData>(20);
    private int numShapes;
    private int numStrings;
    private int numImages;

    public FadeAnim() {
        this.setBackground(Color.BLACK);
        this.setStrings(2);
        this.setImages(3);
        this.setShapes(8);
        this.setControls(new Component[]{new DemoControls(this)});
        this.setConstraints(new String[]{"East"});
    }

    public void setImages(int num) {
        if (num < this.numImages) {
            ArrayList<ObjectData> images = new ArrayList<ObjectData>(this.objects.size());
            for (ObjectData obj : this.objects) {
                if (!(obj.object instanceof Image)) continue;
                images.add(obj);
            }
            this.objects.removeAll(images.subList(num, images.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numImages; i < num; ++i) {
                Image obj = this.getImage(imgs[i % imgs.length]);
                if (imgs[i % imgs.length].equals("jumptojavastrip.png")) {
                    int iw = obj.getWidth(null);
                    int ih = obj.getHeight(null);
                    BufferedImage bimage = new BufferedImage(iw, ih, 1);
                    bimage.createGraphics().drawImage(obj, 0, 0, null);
                    obj = bimage;
                }
                ObjectData od = new ObjectData(obj, Color.BLACK);
                od.reset(d.width, d.height);
                this.objects.add(od);
            }
        }
        this.numImages = num;
    }

    public void setStrings(int num) {
        if (num < this.numStrings) {
            ArrayList<ObjectData> textDatas = new ArrayList<ObjectData>(this.objects.size());
            for (ObjectData obj : this.objects) {
                if (!(obj.object instanceof TextData)) continue;
                textDatas.add(obj);
            }
            this.objects.removeAll(textDatas.subList(num, textDatas.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numStrings; i < num; ++i) {
                int j = i % fonts.length;
                int k = i % strings.length;
                TextData obj = new TextData(strings[k], fonts[j], this);
                ObjectData od = new ObjectData(obj, paints[i % paints.length]);
                od.reset(d.width, d.height);
                this.objects.add(od);
            }
        }
        this.numStrings = num;
    }

    public void setShapes(int num) {
        if (num < this.numShapes) {
            ArrayList<ObjectData> shapes = new ArrayList<ObjectData>(this.objects.size());
            for (ObjectData obj : this.objects) {
                if (!(obj.object instanceof Shape)) continue;
                shapes.add(obj);
            }
            this.objects.removeAll(shapes.subList(num, shapes.size()));
        } else {
            Dimension d = this.getSize();
            for (int i = this.numShapes; i < num; ++i) {
                Shape obj = null;
                switch (i % 7) {
                    case 0: {
                        obj = new GeneralPath();
                        break;
                    }
                    case 1: {
                        obj = new Rectangle2D.Double();
                        break;
                    }
                    case 2: {
                        obj = new Ellipse2D.Double();
                        break;
                    }
                    case 3: {
                        obj = new Arc2D.Double();
                        break;
                    }
                    case 4: {
                        obj = new RoundRectangle2D.Double();
                        break;
                    }
                    case 5: {
                        obj = new CubicCurve2D.Double();
                        break;
                    }
                    case 6: {
                        obj = new QuadCurve2D.Double();
                    }
                }
                ObjectData od = new ObjectData(obj, paints[i % paints.length]);
                od.reset(d.width, d.height);
                this.objects.add(od);
            }
        }
        this.numShapes = num;
    }

    @Override
    public void reset(int w, int h) {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.get(i).reset(w, h);
        }
    }

    @Override
    public void step(int w, int h) {
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.get(i).step(w, h);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectData od = this.objects.get(i);
            AlphaComposite ac = AlphaComposite.getInstance(3, od.alpha);
            g2.setComposite(ac);
            g2.setPaint(od.paint);
            g2.translate(od.x, od.y);
            if (od.object instanceof Image) {
                g2.drawImage((Image)od.object, 0, 0, this);
            } else if (od.object instanceof TextData) {
                g2.setFont(((TextData)od.object).font);
                g2.drawString(((TextData)od.object).string, 0, 0);
            } else if (od.object instanceof QuadCurve2D || od.object instanceof CubicCurve2D) {
                g2.setStroke(bs);
                g2.draw((Shape)od.object);
            } else if (od.object instanceof Shape) {
                g2.fill((Shape)od.object);
            }
            g2.translate(-od.x, -od.y);
        }
    }

    public static void main(String[] argv) {
        FadeAnim.createDemoFrame(new FadeAnim());
    }

    static {
        int w = 10;
        int h = 10;
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D gi = bi.createGraphics();
        Color oc = Color.BLUE;
        Color ic = Color.GREEN;
        gi.setPaint(new GradientPaint(0.0f, 0.0f, oc, (float)w * 0.35f, (float)h * 0.35f, ic));
        gi.fillRect(0, 0, w / 2, h / 2);
        gi.setPaint(new GradientPaint(w, 0.0f, oc, (float)w * 0.65f, (float)h * 0.35f, ic));
        gi.fillRect(w / 2, 0, w / 2, h / 2);
        gi.setPaint(new GradientPaint(0.0f, h, oc, (float)w * 0.35f, (float)h * 0.65f, ic));
        gi.fillRect(0, h / 2, w / 2, h / 2);
        gi.setPaint(new GradientPaint(w, h, oc, (float)w * 0.65f, (float)h * 0.65f, ic));
        gi.fillRect(w / 2, h / 2, w / 2, h / 2);
        texturePaint = new TexturePaint(bi, new Rectangle(0, 0, w, h));
        bs = new BasicStroke(6.0f);
        fonts = new Font[]{new Font("Serif", 0, 64), new Font("Serif", 3, 24), new Font("Monospaced", 1, 36), new Font("SansSerif", 3, 48), new Font("SansSerif", 0, 52)};
        strings = new String[]{"Alpha", "Composite", "Src", "SrcOver", "SrcIn", "SrcOut", "Clear", "DstOver", "DstIn"};
        imgs = new String[]{"jumptojavastrip.png", "duke.png", "star7.png"};
        paints = new Paint[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.CYAN, texturePaint, Color.YELLOW, Color.LIGHT_GRAY, Color.WHITE};
    }

    static class DemoControls
    extends CustomControls
    implements ChangeListener {
        FadeAnim demo;
        JSlider shapeSlider;
        JSlider stringSlider;
        JSlider imageSlider;
        Font font = new Font("Serif", 1, 10);

        public DemoControls(FadeAnim demo) {
            super(demo.name);
            this.demo = demo;
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalStrut(5));
            JToolBar toolbar = new JToolBar(1);
            toolbar.setFloatable(false);
            this.shapeSlider = new JSlider(0, 0, 20, demo.numShapes);
            this.shapeSlider.addChangeListener(this);
            TitledBorder tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numShapes) + " Shapes");
            this.shapeSlider.setBorder(tb);
            this.shapeSlider.setPreferredSize(new Dimension(80, 45));
            this.shapeSlider.setOpaque(true);
            toolbar.addSeparator();
            toolbar.add(this.shapeSlider);
            toolbar.addSeparator();
            this.stringSlider = new JSlider(0, 0, 10, demo.numStrings);
            this.stringSlider.addChangeListener(this);
            tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numStrings) + " Strings");
            this.stringSlider.setBorder(tb);
            this.stringSlider.setPreferredSize(new Dimension(80, 45));
            this.stringSlider.setOpaque(true);
            toolbar.add(this.stringSlider);
            toolbar.addSeparator();
            this.imageSlider = new JSlider(0, 0, 10, demo.numImages);
            this.imageSlider.addChangeListener(this);
            tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(this.font);
            tb.setTitle(String.valueOf(demo.numImages) + " Images");
            this.imageSlider.setBorder(tb);
            this.imageSlider.setPreferredSize(new Dimension(80, 45));
            this.imageSlider.setOpaque(true);
            toolbar.add(this.imageSlider);
            toolbar.addSeparator();
            this.add(toolbar);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            int value = slider.getValue();
            TitledBorder tb = (TitledBorder)slider.getBorder();
            if (slider.equals(this.shapeSlider)) {
                tb.setTitle(String.valueOf(value) + " Shapes");
                this.demo.setShapes(value);
            } else if (slider.equals(this.stringSlider)) {
                tb.setTitle(String.valueOf(value) + " Strings");
                this.demo.setStrings(value);
            } else if (slider.equals(this.imageSlider)) {
                tb.setTitle(String.valueOf(value) + " Images");
                this.demo.setImages(value);
            }
            slider.repaint();
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(80, 0);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (InterruptedException e) {
                return;
            }
            this.shapeSlider.setValue((int)(Math.random() * 5.0));
            this.stringSlider.setValue(10);
            this.thread = null;
        }
    }

    static class ObjectData {
        final int UP = 0;
        final int DOWN = 1;
        Object object;
        BufferedImage bimg;
        Paint paint;
        double x;
        double y;
        float alpha;
        int alphaDirection;
        int imgX;

        public ObjectData(Object object, Paint paint) {
            this.object = object;
            this.paint = paint;
            if (object instanceof BufferedImage) {
                this.bimg = (BufferedImage)object;
                this.object = this.bimg.getSubimage(0, 0, 80, 80);
            }
            this.getRandomXY(300, 250);
            this.alpha = (float)Math.random();
            this.alphaDirection = Math.random() > 0.5 ? 0 : 1;
        }

        private void getRandomXY(int w, int h) {
            if (this.object instanceof TextData) {
                this.x = Math.random() * (double)(w - ((TextData)this.object).width);
                this.y = Math.random() * (double)h;
                this.y = this.y < (double)((TextData)this.object).height ? (double)((TextData)this.object).height : this.y;
            } else if (this.object instanceof Image) {
                this.x = Math.random() * (double)(w - ((Image)this.object).getWidth(null));
                this.y = Math.random() * (double)(h - ((Image)this.object).getHeight(null));
            } else if (this.object instanceof Shape) {
                Rectangle bounds = ((Shape)this.object).getBounds();
                this.x = Math.random() * (double)(w - bounds.width);
                this.y = Math.random() * (double)(h - bounds.height);
            }
        }

        public void reset(int w, int h) {
            this.getRandomXY(w, h);
            double ww = 20.0 + Math.random() * (double)((w == 0 ? 400 : w) / 4);
            double hh = 20.0 + Math.random() * (double)((h == 0 ? 300 : h) / 4);
            if (this.object instanceof Ellipse2D) {
                ((Ellipse2D)this.object).setFrame(0.0, 0.0, ww, hh);
            } else if (this.object instanceof Rectangle2D) {
                ((Rectangle2D)this.object).setRect(0.0, 0.0, ww, ww);
            } else if (this.object instanceof RoundRectangle2D) {
                ((RoundRectangle2D)this.object).setRoundRect(0.0, 0.0, hh, hh, 20.0, 20.0);
            } else if (this.object instanceof Arc2D) {
                ((Arc2D)this.object).setArc(0.0, 0.0, hh, hh, 45.0, 270.0, 2);
            } else if (this.object instanceof QuadCurve2D) {
                ((QuadCurve2D)this.object).setCurve(0.0, 0.0, (double)w * 0.2, (double)h * 0.4, (double)w * 0.4, 0.0);
            } else if (this.object instanceof CubicCurve2D) {
                ((CubicCurve2D)this.object).setCurve(0.0, 0.0, 30.0, -60.0, 60.0, 60.0, 90.0, 0.0);
            } else if (this.object instanceof GeneralPath) {
                GeneralPath p = new GeneralPath();
                float size = (float)ww;
                p.moveTo(-size / 2.0f, -size / 8.0f);
                p.lineTo(size / 2.0f, -size / 8.0f);
                p.lineTo(-size / 4.0f, size / 2.0f);
                p.lineTo(0.0f, -size / 2.0f);
                p.lineTo(size / 4.0f, size / 2.0f);
                p.closePath();
                this.object = p;
            }
        }

        public void step(int w, int h) {
            if (this.object instanceof BufferedImage) {
                if ((this.imgX += 80) == 800) {
                    this.imgX = 0;
                }
                this.object = this.bimg.getSubimage(this.imgX, 0, 80, 80);
            }
            if (this.alphaDirection == 0) {
                float f;
                this.alpha = (float)((double)this.alpha + 0.05);
                if ((double)f > 0.99) {
                    this.alphaDirection = 1;
                    this.alpha = 1.0f;
                }
            } else if (this.alphaDirection == 1) {
                float f;
                this.alpha = (float)((double)this.alpha - 0.05);
                if ((double)f < 0.01) {
                    this.alphaDirection = 0;
                    this.alpha = 0.0f;
                    this.getRandomXY(w, h);
                }
            }
        }
    }

    static class TextData {
        public String string;
        public Font font;
        public int width;
        public int height;

        public TextData(String str, Font font, Component cmp) {
            this.string = str;
            this.font = font;
            FontMetrics fm = cmp.getFontMetrics(font);
            this.width = fm.stringWidth(str);
            this.height = fm.getHeight();
        }
    }
}

