/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001BC\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0000J\b\u0010!\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "", "allocations", "", "Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "oversending", "", "idealBps", "", "targetBps", "suspendedSources", "", "", "(Ljava/util/Set;ZJJLjava/util/List;)V", "getAllocations", "()Ljava/util/Set;", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "forwardedEndpoints", "getForwardedEndpoints", "forwardedSources", "getForwardedSources", "hasSuspendedSources", "getHasSuspendedSources", "()Z", "getIdealBps", "()J", "getOversending", "getTargetBps", "isTheSameAs", "other", "toString", "jitsi-videobridge"})
public final class BandwidthAllocation {
    @NotNull
    private final Set<SingleAllocation> allocations;
    private final boolean oversending;
    private final long idealBps;
    private final long targetBps;
    @NotNull
    private final List<String> suspendedSources;
    private final boolean hasSuspendedSources;
    @NotNull
    private final Set<String> forwardedEndpoints;
    @NotNull
    private final Set<String> forwardedSources;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps, long targetBps, @NotNull List<String> suspendedSources) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SingleAllocation it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(allocations, "allocations");
        Intrinsics.checkNotNullParameter(suspendedSources, "suspendedSources");
        this.allocations = allocations;
        this.oversending = oversending;
        this.idealBps = idealBps;
        this.targetBps = targetBps;
        this.suspendedSources = suspendedSources;
        this.hasSuspendedSources = !((Collection)this.suspendedSources).isEmpty();
        Iterable iterable = this.allocations;
        BandwidthAllocation bandwidthAllocation = this;
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleAllocation)element$iv$iv;
            boolean bl = false;
            if (!it.isForwarded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SingleAllocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEndpointId());
        }
        bandwidthAllocation.forwardedEndpoints = CollectionsKt.toSet((List)destination$iv$iv);
        $this$map$iv = this.allocations;
        bandwidthAllocation = this;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleAllocation)element$iv$iv;
            boolean bl = false;
            if (!it.isForwarded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SingleAllocation it2 = (SingleAllocation)element$iv$iv;
            boolean bl2 = false;
            MediaSourceDesc mediaSourceDesc = it2.getMediaSource();
            if ((mediaSourceDesc != null ? mediaSourceDesc.getSourceName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        bandwidthAllocation.forwardedSources = CollectionsKt.toSet((List)destination$iv$iv);
    }

    public /* synthetic */ BandwidthAllocation(Set set, boolean bl, long l, long l2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        if ((n & 8) != 0) {
            l2 = -1L;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(set, bl, l, l2, list);
    }

    @NotNull
    public final Set<SingleAllocation> getAllocations() {
        return this.allocations;
    }

    public final boolean getOversending() {
        return this.oversending;
    }

    public final long getIdealBps() {
        return this.idealBps;
    }

    public final long getTargetBps() {
        return this.targetBps;
    }

    public final boolean getHasSuspendedSources() {
        return this.hasSuspendedSources;
    }

    @NotNull
    public final Set<String> getForwardedEndpoints() {
        return this.forwardedEndpoints;
    }

    @NotNull
    public final Set<String> getForwardedSources() {
        return this.forwardedSources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTheSameAs(@NotNull BandwidthAllocation other) {
        boolean bl;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.allocations.size() != other.allocations.size()) return false;
        if (this.oversending != other.oversending) return false;
        Iterable $this$all$iv = this.allocations;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            boolean bl2;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            SingleAllocation allocation = (SingleAllocation)element$iv;
            boolean bl3 = false;
            Iterable $this$any$iv = other.allocations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator3 = $this$any$iv.iterator();
            do {
                if (!iterator3.hasNext()) return false;
                Object element$iv2 = iterator3.next();
                SingleAllocation otherAllocation = (SingleAllocation)element$iv2;
                boolean bl4 = false;
                if (Intrinsics.areEqual(allocation.getEndpointId(), otherAllocation.getEndpointId())) {
                    MediaSourceDesc mediaSourceDesc = allocation.getMediaSource();
                    MediaSourceDesc mediaSourceDesc2 = otherAllocation.getMediaSource();
                    if (Intrinsics.areEqual(mediaSourceDesc != null ? Long.valueOf(mediaSourceDesc.getPrimarySSRC()) : null, mediaSourceDesc2 != null ? Long.valueOf(mediaSourceDesc2.getPrimarySSRC()) : null)) {
                        RtpLayerDesc rtpLayerDesc = allocation.getTargetLayer();
                        RtpLayerDesc rtpLayerDesc2 = otherAllocation.getTargetLayer();
                        if (Intrinsics.areEqual(rtpLayerDesc != null ? Integer.valueOf(rtpLayerDesc.getIndex()) : null, rtpLayerDesc2 != null ? Integer.valueOf(rtpLayerDesc2.getIndex()) : null)) {
                            bl2 = true;
                            continue;
                        }
                    }
                }
                bl2 = false;
            } while (!bl2);
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    public String toString() {
        return "oversending=" + this.oversending + " " + CollectionsKt.joinToString$default(this.allocations, null, null, null, 0, null, null, 63, null);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d6 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_debugState__u24lambda_u2d6.put("idealBps", this.idealBps);
        $this$_get_debugState__u24lambda_u2d6.put("targetBps", this.targetBps);
        $this$_get_debugState__u24lambda_u2d6.put("oversending", this.oversending);
        $this$_get_debugState__u24lambda_u2d6.put("has_suspended_sources", this.hasSuspendedSources);
        $this$_get_debugState__u24lambda_u2d6.put("suspended_sources", this.suspendedSources);
        return jSONObject;
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps, long targetBps) {
        Intrinsics.checkNotNullParameter(allocations, "allocations");
        this(allocations, oversending, idealBps, targetBps, null, 16, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending, long idealBps) {
        Intrinsics.checkNotNullParameter(allocations, "allocations");
        this(allocations, oversending, idealBps, 0L, null, 24, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations, boolean oversending) {
        Intrinsics.checkNotNullParameter(allocations, "allocations");
        this(allocations, oversending, 0L, 0L, null, 28, null);
    }

    @JvmOverloads
    public BandwidthAllocation(@NotNull Set<SingleAllocation> allocations) {
        Intrinsics.checkNotNullParameter(allocations, "allocations");
        this(allocations, false, 0L, 0L, null, 30, null);
    }
}

