// Copyright 2021 Grafana Labs
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package grafanaplugin

import (
	"github.com/grafana/thema"
	ui "github.com/grafana/grafana/packages/grafana-schema/src/schema"
)

Panel: thema.#Lineage & {
	name: "table"
	seqs: [
		{
			schemas: [
				{
					PanelOptions: {
						frameIndex:    number | *0
						showHeader:    bool | *true
						showTypeIcons: bool | *false
						sortBy?: [...ui.TableSortByFieldState]
					} @cuetsy(kind="interface")
					PanelFieldConfig: ui.TableFieldOptions & {} @cuetsy(kind="interface")
				},
			]
		},
	]
}
