/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jde.util.ClassPathDir;
import jde.util.ClassPathZip;
import jde.util.MultiValueMap;

abstract class ClassPathEntry {
    protected MultiValueMap nameToClassMap = new MultiValueMap();
    protected boolean loaded = false;
    private static Map entryMap = new HashMap();

    ClassPathEntry() {
    }

    static ClassPathEntry instanceForEntry(File resource) throws IOException {
        ClassPathEntry entry = null;
        if (entryMap.containsKey(resource)) {
            entry = (ClassPathEntry)entryMap.get(resource);
        } else {
            entry = resource.getName().toLowerCase().endsWith(".jar") ? new ClassPathZip(resource) : (resource.getName().toLowerCase().endsWith(".zip") ? new ClassPathZip(resource) : (resource.isDirectory() ? new ClassPathDir(resource) : null));
            if (null != entry) {
                entryMap.put(resource, entry);
            }
        }
        return entry;
    }

    abstract void load() throws IOException;

    void clear() {
        this.nameToClassMap.clear();
        this.setLoaded(false);
    }

    void reload() throws IOException {
        this.clear();
        this.load();
    }

    protected void addClass(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        int innerClass = qualifiedName.indexOf(36);
        String unqualified = innerClass < 0 ? qualifiedName.substring(lastDot + 1) : qualifiedName.substring(innerClass + 1);
        this.nameToClassMap.put(unqualified, qualifiedName);
    }

    List getClassNames(String unqualifiedName) throws IOException {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.nameToClassMap.getAsList(unqualifiedName);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

