;;; liece-globals.el --- Global variables and constants.
;; Copyright (C) 1998-2000 Daiki Ueno

;; Author: Daiki Ueno <ueno@unixuser.org>
;; Created: 1998-09-28
;; Revised: 1998-11-25
;; Keywords: IRC, liece

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;; 

;;; Code:

(require 'liece-version)

(defvar liece-server-name nil)
(defvar liece-server-process nil)
(defvar liece-status-message-string nil)
(defvar liece-polling 0
  "Wheter we are automatically polling the server.")

(defvar liece-real-nickname nil)
(defvar liece-nick-accepted nil)

(defvar liece-current-channel nil
  "The channel you currently have joined.")

(defvar liece-current-channels nil
  "The channels you have currently joined.")

(defvar liece-current-chat-partner nil
  "The person you are in a private conversation with.")

(defvar liece-current-chat-partners nil
  "An list containing nics user is chatting with.")

(defvar liece-privmsg-partner nil
  "The person who got your last private message.")

(defvar liece-nick-alist nil
  "An alist containing the nicknames of users known to be on IRC.
Each element in the list is a list containing a nickname.")

(defvar liece-channel-alist nil
  "An alist containing the channels on IRC.
Each element in the list is  a list containing a channel name.")

(defvar liece-operator-alist nil
  "An alist of operators on channel.
Each element in the list is a list containing a nickname.")

(defvar liece-supported-user-mode-alist nil
  "User modes supported by server.")

(defvar liece-supported-channel-mode-alist nil
  "Channel modes supported by server.")

;; Caches
(defvar liece-save-variables-are-dirty nil
  "Non nil if liece_vars.el is changed but not saved.")

(defvar liece-user-at-host ""
  "The user@host for the current line.")

(defvar liece-user-at-host-type nil
  "The authentication of uerathost.  'ok 'not-verified 'fake or 'invalid.")

(defvar liece-channel-filter ""
  "Enables use of \\[universal-argument] with NAMES and TOPIC.")

(defvar liece-default-channel-candidate nil)

(defvar liece-nickname-last nil
  "Place to keep old nickname.")

(defvar liece-friends-last nil)
(defvar liece-who-expression nil)

(defconst liece-long-reply-max 38)
(defvar liece-long-reply-count 0)

(defvar liece-obarray nil)


;; Modeline indicators
(defvar liece-channel-indicator "No channel"
  "The current channel, \"pretty-printed.\".")

(defvar liece-private-indicator nil
  "String displayed in the modeline indicating private conversation.")

(defvar liece-channels-indicator "No channel"
  "The current joined channels, \"pretty-printed.\".")

(defvar liece-away-indicator "-")
(defvar liece-command-buffer-mode-indicator "Channels")
(defvar liece-channel-status-indicator "")

(defvar liece-beep-indicator nil)
(defvar liece-freeze-indicator nil)
(defvar liece-own-freeze-indicator nil)
(defvar liece-beep nil)
(defvar liece-freeze nil)
(defvar liece-own-freeze nil)

(defvar liece-own-freeze nil
  "If non-nil, dialogue window will not be scrolled automatically.")

(defvar liece-command-buffer-mode 'channel
  "Current command buffer mode.
Which value is 'chat or 'channel.")

;; Buffers
(defvar liece-command-buffer "*Commands*"
  "Name of command input buffer.")

(defvar liece-dialogue-buffer "*Dialogue*"
  "Name of dialogue output buffer.")

(defvar liece-private-buffer "*Private*"
  "Name of private message buffer.")

(defvar liece-others-buffer "*Others*"
  "Name of others message buffer.")

(defvar liece-channel-buffer "*Channel*"
  "Name of Channel message buffer.")

(defvar liece-channel-buffer-format " *Channel:%s*"
  "Format of Channel message buffer.")

(defvar liece-channel-list-buffer "*Channels*"
  "Name of Channel list buffer.")

(defvar liece-nick-buffer " *Nicks*"
  "Name of nick list message buffer.")

(defvar liece-nick-buffer-format " *Nicks:%s*"
  "Format of nick list buffer.")

(defvar liece-KILLS-buffer " *KILLS*")
(defvar liece-IGNORED-buffer " *IGNORED*")
(defvar liece-WALLOPS-buffer " *WALLOPS*")

(defvar liece-server-buffer nil)

;; Buffer display variables
(defvar liece-channel-buffer-alist nil)
(defvar liece-nick-buffer-alist nil)

(defvar liece-buffer-list nil
  "A list of buffers used in displaying messages.")

(defvar liece-D-buffer (list liece-dialogue-buffer)
  "A list of buffer where normal dialogue is sent.")

(defvar liece-O-buffer (list liece-others-buffer)
  "A list of buffer where other messages are sent.")

(defvar liece-P-buffer
  (list liece-dialogue-buffer liece-private-buffer liece-others-buffer)
  "A list of buffers where private messages to me are sent.")

(defvar liece-I-buffer (list liece-IGNORED-buffer)
  "A list of buffers where private messages to me are sent.")

(defvar liece-W-buffer (list liece-WALLOPS-buffer)
  "A list of buffers where WALLOPS messages to me are sent.")

(defvar liece-K-buffer (list liece-KILLS-buffer)
  "A list of buffers where KILL messages to me are sent.")

(defvar liece-000-buffer
  (list liece-dialogue-buffer liece-others-buffer)
  "A list of buffers where 000 messages to me are sent.")

(defvar liece-200-buffer
  (list liece-dialogue-buffer liece-others-buffer)
  "A list of buffers where 200 messages to me are sent.")

(defvar liece-300-buffer
  (list liece-dialogue-buffer liece-others-buffer)
  "A list of buffers where 300 messages to me are sent.")

(defvar liece-400-buffer
  (list liece-dialogue-buffer liece-others-buffer)
  "A list of buffers where 400 messages to me are sent.")

(defvar liece-500-buffer
  (list liece-dialogue-buffer liece-others-buffer)
  "A list of buffers where 500 messages to me are sent.")

(provide 'liece-globals)

;;; liece-globals.el ends here
