/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceAfterCheck
extends Check {
    private boolean mAllowLineBreaks = true;

    public int[] getDefaultTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59};
    }

    public void visitToken(DetailAST aAST) {
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (after >= line.length() || Character.isWhitespace(line.charAt(after))) {
            boolean flag = !this.mAllowLineBreaks;
            int i = after + 1;
            while (!flag && i < line.length()) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    flag = true;
                }
                ++i;
            }
            if (flag) {
                this.log(aAST.getLineNo(), after, "ws.followed", (Object)aAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

