/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractImportCheck;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UnusedImportsCheck
extends AbstractImportCheck {
    private boolean mCollect;
    private final Set mImports = new HashSet();
    private final Set mReferenced = new HashSet();

    public void beginTree(DetailAST aRootAST) {
        this.mCollect = false;
        this.mImports.clear();
        this.mReferenced.clear();
    }

    public void finishTree(DetailAST aRootAST) {
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            FullIdent imp = (FullIdent)it.next();
            if (this.mReferenced.contains(Utils.baseClassname(imp.getText()))) continue;
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", (Object)imp.getText());
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 14, 15, 58};
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 58) {
            if (this.mCollect) {
                this.processIdent(aAST);
            }
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else if (aAST.getType() == 14 || aAST.getType() == 15) {
            this.mCollect = true;
        }
    }

    private void processIdent(DetailAST aAST) {
        DetailAST parent = aAST.getParent();
        if (parent.getType() == 59) {
            if (aAST.getNextSibling() != null) {
                this.mReferenced.add(aAST.getText());
            }
        } else {
            this.mReferenced.add(aAST.getText());
        }
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = this.getImportText(aAST);
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }
}

