/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dbproc;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dbproc.DBProcData;
import org.pentaho.di.trans.steps.dbproc.DBProcMeta;
import org.pentaho.di.trans.steps.dbproc.Messages;

public class DBProc
extends BaseStep
implements StepInterface {
    private DBProcMeta meta;
    private DBProcData data;

    public DBProc(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] runProc(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this);
            this.data.argnrs = new int[this.meta.getArgument().length];
            for (int i = 0; i < this.meta.getArgument().length; ++i) {
                if (!this.meta.getArgumentDirection()[i].equalsIgnoreCase("OUT")) {
                    this.data.argnrs[i] = rowMeta.indexOfValue(this.meta.getArgument()[i]);
                    if (this.data.argnrs[i] >= 0) continue;
                    this.logError(Messages.getString("DBProc.Log.ErrorFindingField") + this.meta.getArgument()[i] + "]");
                    throw new KettleStepException(Messages.getString("DBProc.Exception.CouldnotFindField", this.meta.getArgument()[i]));
                }
                this.data.argnrs[i] = -1;
            }
            this.data.db.setProcLookup(this.meta.getProcedure(), this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        }
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputMeta.size());
        int outputIndex = rowMeta.size();
        this.data.db.setProcValues(rowMeta, rowData, this.data.argnrs, this.meta.getArgumentDirection(), !Const.isEmpty((String)this.meta.getResultName()));
        RowMetaAndData add = this.data.db.callProcedure(this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        int addIndex = 0;
        if (!Const.isEmpty((String)this.meta.getResultName())) {
            outputRowData[outputIndex++] = add.getData()[addIndex++];
        }
        for (int i = 0; i < this.data.argnrs.length; ++i) {
            if (this.meta.getArgumentDirection()[i].equalsIgnoreCase("OUT")) {
                outputRowData[outputIndex++] = add.getData()[addIndex++];
                continue;
            }
            if (!this.meta.getArgumentDirection()[i].equalsIgnoreCase("INOUT")) continue;
            outputRowData[this.data.argnrs[i]] = add.getData()[addIndex];
            ++addIndex;
        }
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block7: {
            Object[] r;
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (this.data.readsRows) {
                r = this.getRow();
                if (r == null) {
                    this.setOutputDone();
                    return false;
                }
                this.data.inputRowMeta = this.getInputRowMeta();
            } else {
                r = new Object[]{};
                this.incrementLinesRead();
                this.data.inputRowMeta = new RowMeta();
                this.data.readsRows = true;
            }
            try {
                Object[] outputRowData = this.runProc(this.data.inputRowMeta, r);
                this.putRow(this.data.outputMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("DBProc.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("DBProc.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBP001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block12: {
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            if (super.init(smi, sdi)) {
                this.data.readsRows = false;
                List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
                if (previous != null && previous.size() > 0) {
                    this.data.readsRows = true;
                }
                this.data.db = new Database(this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (!this.meta.isAutoCommit()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(Messages.getString("DBProc.Log.AutoCommit"));
                        }
                        this.data.db.setCommit(9999);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("DBProc.Log.ConnectedToDB"));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(Messages.getString("DBProc.Log.DBException") + e.getMessage());
                    if (this.data.db == null) break block12;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block7: {
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            try {
                block6: {
                    try {
                        if (this.meta.isAutoCommit()) break block6;
                        this.data.db.commit();
                    }
                    catch (KettleDatabaseException e) {
                        this.logError(Messages.getString("DBProc.Log.CommitError") + e.getMessage());
                        Object var5_4 = null;
                        if (this.data.db != null) {
                            this.data.db.disconnect();
                        }
                        break block7;
                    }
                }
                Object var5_3 = null;
                if (this.data.db == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

