/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.parallelgzipcsv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.parallelgzipcsv.Messages;
import org.pentaho.di.trans.steps.parallelgzipcsv.ParGzipCsvInput;
import org.pentaho.di.trans.steps.parallelgzipcsv.ParGzipCsvInputData;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParGzipCsvInputMeta
extends BaseStepMeta
implements StepMetaInterface,
InputFileMetaInterface {
    private String filename;
    private String filenameField;
    private boolean includingFilename;
    private String rowNumField;
    private boolean headerPresent;
    private String delimiter;
    private String enclosure;
    private String bufferSize;
    private boolean lazyConversionActive;
    private TextFileInputField[] inputFields;
    private boolean isaddresult;
    private boolean runningInParallel;
    private String encoding;

    public ParGzipCsvInputMeta() {
        this.allocate(0);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.delimiter = ",";
        this.enclosure = "\"";
        this.headerPresent = true;
        this.lazyConversionActive = true;
        this.isaddresult = false;
        this.bufferSize = "50000";
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_field");
            this.rowNumField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.includingFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_filename"));
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
            this.headerPresent = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.lazyConversionActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"lazy_conversion"));
            this.isaddresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"add_filename_result"));
            this.runningInParallel = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"parallel"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.inputFields[i].setTrimType(ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.inputFields = new TextFileInputField[nrFields];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_filename", (boolean)this.includingFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"separator", (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerPresent));
        retval.append("    ").append(XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lazy_conversion", (boolean)this.lazyConversionActive));
        retval.append("    ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"parallel", (boolean)this.runningInParallel));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)field.getType())));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMeta.getTrimTypeCode((int)field.getTrimType())));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.filenameField = rep.getStepAttributeString(id_step, "filename_field");
            this.rowNumField = rep.getStepAttributeString(id_step, "rownum_field");
            this.includingFilename = rep.getStepAttributeBoolean(id_step, "include_filename");
            this.delimiter = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.headerPresent = rep.getStepAttributeBoolean(id_step, "header");
            this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
            this.lazyConversionActive = rep.getStepAttributeBoolean(id_step, "lazy_conversion");
            this.isaddresult = rep.getStepAttributeBoolean(id_step, "add_filename_result");
            this.runningInParallel = rep.getStepAttributeBoolean(id_step, "parallel");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                this.inputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.inputFields[i].setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                this.inputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.inputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.inputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.inputFields[i].setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.inputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.inputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.inputFields[i].setTrimType(ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "filename_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumField);
            rep.saveStepAttribute(id_transformation, id_step, "include_filename", this.includingFilename);
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerPresent);
            rep.saveStepAttribute(id_transformation, id_step, "lazy_conversion", this.lazyConversionActive);
            rep.saveStepAttribute(id_transformation, id_step, "add_filename_result", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "parallel", this.runningInParallel);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            for (int i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", ValueMeta.getTypeDesc((int)field.getType()));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", ValueMeta.getTrimTypeCode((int)field.getTrimType()));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        rowMeta.clear();
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            ValueMeta valueMeta = new ValueMeta(field.getName(), field.getType());
            valueMeta.setConversionMask(field.getFormat());
            valueMeta.setLength(field.getLength());
            valueMeta.setPrecision(field.getPrecision());
            valueMeta.setConversionMask(field.getFormat());
            valueMeta.setDecimalSymbol(field.getDecimalSymbol());
            valueMeta.setGroupingSymbol(field.getGroupSymbol());
            valueMeta.setCurrencySymbol(field.getCurrencySymbol());
            valueMeta.setTrimType(field.getTrimType());
            if (this.lazyConversionActive) {
                valueMeta.setStorageType(1);
            }
            valueMeta.setStringEncoding(space.environmentSubstitute(this.encoding));
            ValueMetaInterface storageMetadata = valueMeta.clone();
            storageMetadata.setType(2);
            storageMetadata.setStorageType(0);
            storageMetadata.setLength(-1, -1);
            valueMeta.setStorageMetadata(storageMetadata);
            valueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        }
        if (!Const.isEmpty((String)this.filenameField) && this.includingFilename) {
            ValueMeta filenameMeta = new ValueMeta(this.filenameField, 2);
            filenameMeta.setOrigin(origin);
            if (this.lazyConversionActive) {
                filenameMeta.setStorageType(1);
                filenameMeta.setStorageMetadata((ValueMetaInterface)new ValueMeta(this.filenameField, 2));
            }
            rowMeta.addValueMeta((ValueMetaInterface)filenameMeta);
        }
        if (!Const.isEmpty((String)this.rowNumField)) {
            ValueMeta rowNumMeta = new ValueMeta(this.rowNumField, 5);
            rowNumMeta.setLength(10);
            rowNumMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)rowNumMeta);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, Messages.getString("ParGzipCsvInputMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ParGzipCsvInputMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, Messages.getString("ParGzipCsvInputMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("ParGzipCsvInputMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new ParGzipCsvInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ParGzipCsvInputData();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    @Override
    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Const.isEmpty((String)this.filename)) {
            reference.getEntries().add(new ResourceEntry(transMeta.environmentSubstitute(this.filename), ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Override
    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    @Override
    public int getFileFormatTypeNr() {
        return 2;
    }

    @Override
    public String[] getFilePaths(VariableSpace space) {
        return new String[]{space.environmentSubstitute(this.filename)};
    }

    @Override
    public int getNrHeaderLines() {
        return 1;
    }

    @Override
    public boolean hasHeader() {
        return this.isHeaderPresent();
    }

    @Override
    public String getErrorCountField() {
        return null;
    }

    @Override
    public String getErrorFieldsField() {
        return null;
    }

    @Override
    public String getErrorTextField() {
        return null;
    }

    @Override
    public String getEscapeCharacter() {
        return null;
    }

    @Override
    public String getFileType() {
        return "CSV";
    }

    @Override
    public String getSeparator() {
        return this.delimiter;
    }

    @Override
    public boolean includeFilename() {
        return false;
    }

    @Override
    public boolean includeRowNumber() {
        return false;
    }

    @Override
    public boolean isErrorIgnored() {
        return false;
    }

    @Override
    public boolean isErrorLineSkipped() {
        return false;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludingFilename() {
        return this.includingFilename;
    }

    public void setIncludingFilename(boolean includingFilename) {
        this.includingFilename = includingFilename;
    }

    public String getRowNumField() {
        return this.rowNumField;
    }

    public void setRowNumField(String rowNumField) {
        this.rowNumField = rowNumField;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean isRunningInParallel() {
        return this.runningInParallel;
    }

    public void setRunningInParallel(boolean runningInParallel) {
        this.runningInParallel = runningInParallel;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (Const.isEmpty((String)this.filenameField) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename))).exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

