/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.setvariable;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.setvariable.Messages;
import org.pentaho.di.trans.steps.setvariable.SetVariable;
import org.pentaho.di.trans.steps.setvariable.SetVariableData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetVariableMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int VARIABLE_TYPE_JVM = 0;
    public static final int VARIABLE_TYPE_PARENT_JOB = 1;
    public static final int VARIABLE_TYPE_GRAND_PARENT_JOB = 2;
    public static final int VARIABLE_TYPE_ROOT_JOB = 3;
    private static final String[] variableTypeCode = new String[]{"JVM", "PARENT_JOB", "GP_JOB", "ROOT_JOB"};
    private static final String[] variableTypeDesc = new String[]{"Valid in the Java Virtual Machine", "Valid in the parent job", "Valid in the grand-parent job", "Valid in the root job"};
    private String[] fieldName;
    private String[] variableName;
    private int[] variableType;
    private String[] defaultValue;
    private boolean usingFormatting;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public String[] getVariableName() {
        return this.variableName;
    }

    public int[] getVariableType() {
        return this.variableType;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static final String getVariableTypeCode(int variableType) {
        return variableTypeCode[variableType];
    }

    public static final String getVariableTypeDescription(int variableType) {
        return variableTypeDesc[variableType];
    }

    public static final int getVariableType(String variableType) {
        int i;
        for (i = 0; i < variableTypeCode.length; ++i) {
            if (!variableTypeCode[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        for (i = 0; i < variableTypeDesc.length; ++i) {
            if (!variableTypeDesc[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        return 0;
    }

    public void setVariableType(int[] localVariable) {
        this.variableType = localVariable;
    }

    public static final String[] getVariableTypeDescriptions() {
        return variableTypeDesc;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.variableName = new String[count];
        this.variableType = new int[count];
        this.defaultValue = new String[count];
    }

    @Override
    public Object clone() {
        SetVariableMeta retval = (SetVariableMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.variableName[i] = this.variableName[i];
            retval.variableType[i] = this.variableType[i];
            retval.defaultValue[i] = this.defaultValue[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"field_name");
                this.variableName[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable_name");
                this.variableType[i] = SetVariableMeta.getVariableType(XMLHandler.getTagValue((Node)fnode, (String)"variable_type"));
                this.defaultValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"default_value");
            }
            this.usingFormatting = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_formatting"));
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("SetVariableMeta.RuntimeError.UnableToReadXML.SETVARIABLE0004"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.variableName[i] = "";
            this.variableType[i] = 0;
            this.defaultValue[i] = "";
        }
        this.usingFormatting = true;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(150);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"variable_name", (String)this.variableName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"variable_type", (String)SetVariableMeta.getVariableTypeCode(this.variableType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default_value", (String)this.defaultValue[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_formatting", (boolean)this.usingFormatting));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.variableName[i] = rep.getStepAttributeString(id_step, i, "variable_name");
                this.variableType[i] = SetVariableMeta.getVariableType(rep.getStepAttributeString(id_step, i, "variable_type"));
                this.defaultValue[i] = rep.getStepAttributeString(id_step, i, "default_value");
            }
            this.usingFormatting = rep.getStepAttributeBoolean(id_step, 0, "use_formatting", false);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SetVariableMeta.RuntimeError.UnableToReadRepository.SETVARIABLE0005"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "variable_name", this.variableName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "variable_type", SetVariableMeta.getVariableTypeCode(this.variableType[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "default_value", this.defaultValue[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, 0L, "use_formatting", this.usingFormatting);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SetVariableMeta.RuntimeError.UnableToSaveRepository.SETVARIABLE0006", "" + id_step), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("SetVariableMeta.CheckResult.NotReceivingFieldsFromPreviousSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("SetVariableMeta.CheckResult.ReceivingFieldsFromPreviousSteps", "" + prev.size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("SetVariableMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("SetVariableMeta.CheckResult.NotReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SetVariable(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SetVariableData();
    }

    public boolean isUsingFormatting() {
        return this.usingFormatting;
    }

    public void setUsingFormatting(boolean usingFormatting) {
        this.usingFormatting = usingFormatting;
    }
}

