/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.switchcase.ContainsKeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.KeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.Messages;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;

public class SwitchCase
extends BaseStep
implements StepInterface {
    private SwitchCaseMeta meta;
    private SwitchCaseData data;

    public SwitchCase(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowSet rowSet;
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.getInputRowMeta(), this.getStepname(), null, null, this);
            this.data.fieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getFieldname());
            if (this.data.fieldIndex < 0) {
                throw new KettleException(Messages.getString("SwitchCase.Exception.UnableToFindFieldName", this.meta.getFieldname()));
            }
            this.data.inputValueMeta = this.getInputRowMeta().getValueMeta(this.data.fieldIndex);
            try {
                for (int i = 0; i < this.meta.getCaseTargetSteps().length; ++i) {
                    if (this.meta.getCaseTargetSteps()[i] == null) {
                        throw new KettleException(Messages.getString("SwitchCase.Log.NoTargetStepSpecifiedForValue", this.meta.getCaseValues()[i]));
                    }
                    rowSet = this.findOutputRowSet(this.meta.getCaseTargetSteps()[i].getName());
                    if (rowSet != null) {
                        try {
                            Object value = this.data.valueMeta.convertDataFromString(this.meta.getCaseValues()[i], this.data.stringValueMeta, null, null, 0);
                            if (this.data.valueMeta.isNull(value)) {
                                this.data.nullRowSet = rowSet;
                                continue;
                            }
                            this.data.outputMap.put(value, rowSet);
                            continue;
                        }
                        catch (Exception e) {
                            throw new KettleException(Messages.getString("SwitchCase.Log.UnableToConvertValue", this.meta.getCaseValues()[i]), (Throwable)e);
                        }
                    }
                    throw new KettleException(Messages.getString("SwitchCase.Log.UnableToFindTargetRowSetForStep", this.meta.getCaseTargetSteps()[i].getName()));
                }
                this.data.defaultRowSet = this.meta.getDefaultTargetStep() != null ? this.findOutputRowSet(this.meta.getDefaultTargetStep().getName()) : null;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        Object lookupData = this.data.valueMeta.convertData(this.data.inputValueMeta, r[this.data.fieldIndex]);
        rowSet = null;
        rowSet = this.data.inputValueMeta.isNull(lookupData) ? this.data.nullRowSet : this.data.outputMap.get(lookupData);
        if (rowSet == null) {
            if (this.data.defaultRowSet != null) {
                this.putRowTo(this.data.outputRowMeta, r, this.data.defaultRowSet);
            }
        } else {
            this.putRowTo(this.data.outputRowMeta, r, rowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("SwitchCase.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SwitchCaseMeta)smi;
        this.data = (SwitchCaseData)sdi;
        if (super.init(smi, sdi)) {
            KeyToRowSetMap keyToRowSetMap = this.data.outputMap = this.meta.isContains() ? new ContainsKeyToRowSetMap() : new KeyToRowSetMap();
            if (Const.isEmpty((String)this.meta.getFieldname())) {
                this.logError(Messages.getString("SwitchCase.Log.NoFieldSpecifiedToSwitchWith"));
                return false;
            }
            this.data.valueMeta = new ValueMeta(this.meta.getFieldname(), this.meta.getCaseValueType());
            this.data.valueMeta.setConversionMask(this.meta.getCaseValueFormat());
            this.data.valueMeta.setGroupingSymbol(this.meta.getCaseValueGroup());
            this.data.valueMeta.setDecimalSymbol(this.meta.getCaseValueDecimal());
            this.data.stringValueMeta = this.data.valueMeta.clone();
            this.data.stringValueMeta.setType(2);
            return true;
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

