/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestDirOperations
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestDirOperations.java,v 1.7 2005/07/15 17:30:06 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestDirOperations;

    protected String getLogName() {
        return "TestDirOperations.log";
    }

    public void testDir() throws Exception {
        this.log.debug("testMkDir()");
        this.connect();
        this.ftp.chdir(this.testdir);
        String dir = this.generateRandomFilename();
        this.ftp.mkdir(dir);
        this.ftp.chdir(dir);
        String wd = this.ftp.pwd();
        this.log.debug("PWD: " + wd);
        Assert.assertTrue((wd.indexOf(dir) >= 0 ? 1 : 0) != 0);
        this.ftp.chdir("..");
        this.ftp.rmdir(dir);
        try {
            this.ftp.chdir(dir);
            Assert.fail((String)("chdir(" + dir + ") should have failed!"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testRenameDir() throws Exception {
        this.log.debug("testRenameDir()");
        this.connect();
        this.ftp.chdir(this.testdir);
        String dir1 = this.generateRandomFilename();
        this.ftp.mkdir(dir1);
        this.ftp.chdir(dir1);
        this.ftp.chdir("..");
        String dir2 = new StringBuffer(dir1).reverse().toString();
        this.ftp.rename(dir1, dir2);
        this.ftp.chdir(dir2);
        String wd = this.ftp.pwd();
        Assert.assertTrue((wd.indexOf(dir2) >= 0 ? 1 : 0) != 0);
        this.ftp.chdir("..");
        this.ftp.rmdir(dir2);
        try {
            this.ftp.chdir(dir2);
            Assert.fail((String)("chdir(" + dir2 + ") should have failed!"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestDirOperations != null ? class$com$enterprisedt$net$ftp$test$TestDirOperations : (class$com$enterprisedt$net$ftp$test$TestDirOperations = FTPTestCase.class$("com.enterprisedt.net.ftp.test.TestDirOperations")));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestDirOperations.suite());
    }
}

