/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

final class CompiledStatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private IntKeyHashMap sqlLookup;
    private IntKeyHashMap csidMap;
    private IntKeyHashMap sessionUseMap;
    private IntKeyIntValueHashMap useMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new IntKeyHashMap();
        this.csidMap = new IntKeyHashMap();
        this.sessionUseMap = new IntKeyHashMap();
        this.useMap = new IntKeyIntValueHashMap();
        this.next_cs_id = 0;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionUseMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    synchronized void resetStatements() {
        Iterator iterator = this.csidMap.values().iterator();
        while (iterator.hasNext()) {
            CompiledStatement compiledStatement = (CompiledStatement)iterator.next();
            compiledStatement.clearVariables();
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private int getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (intValueHashMap == null) {
            return -1;
        }
        return intValueHashMap.get((Object)string, -1);
    }

    synchronized CompiledStatement getStatement(Session session, int n) {
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n);
        if (compiledStatement == null) {
            return null;
        }
        if (!compiledStatement.isValid) {
            String string = (String)this.sqlLookup.get(n);
            try {
                compiledStatement = this.compileSql(session, string, compiledStatement.schemaHsqlName.name);
                compiledStatement.id = n;
                this.csidMap.put(n, compiledStatement);
            }
            catch (Throwable throwable) {
                this.freeStatement(n, session.getId(), true);
                return null;
            }
        }
        return compiledStatement;
    }

    private void linkSession(int n, int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(n2);
        if (intKeyIntValueHashMap == null) {
            intKeyIntValueHashMap = new IntKeyIntValueHashMap();
            this.sessionUseMap.put(n2, intKeyIntValueHashMap);
        }
        int n3 = intKeyIntValueHashMap.get(n, 0);
        intKeyIntValueHashMap.put(n, n3 + 1);
        if (n3 == 0) {
            this.useMap.put(n, this.useMap.get(n, 0) + 1);
        }
    }

    private int registerStatement(int n, CompiledStatement compiledStatement) {
        if (n < 0) {
            n = this.nextID();
            int n2 = compiledStatement.schemaHsqlName.hashCode();
            IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n2);
            if (intValueHashMap == null) {
                intValueHashMap = new IntValueHashMap();
                this.schemaMap.put(n2, intValueHashMap);
            }
            intValueHashMap.put(compiledStatement.sql, n);
            this.sqlLookup.put(n, compiledStatement.sql);
        }
        compiledStatement.id = n;
        this.csidMap.put(n, compiledStatement);
        return n;
    }

    void freeStatement(int n, int n2, boolean bl) {
        if (n == -1) {
            return;
        }
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(n2);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        int n3 = intKeyIntValueHashMap.get(n, 0);
        if (n3 != 0) {
            if (n3 == 1 || bl) {
                intKeyIntValueHashMap.remove(n);
                int n4 = this.useMap.get(n, 0);
                if (n4 != 0) {
                    if (n4 == 1) {
                        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n);
                        if (compiledStatement != null) {
                            int n5 = compiledStatement.schemaHsqlName.hashCode();
                            IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n5);
                            String string = (String)this.sqlLookup.remove(n);
                            intValueHashMap.remove(string);
                        }
                        this.useMap.remove(n);
                    } else {
                        this.useMap.put(n, n4 - 1);
                    }
                }
            } else {
                intKeyIntValueHashMap.put(n, n3 - 1);
            }
        }
    }

    synchronized void removeSession(int n) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.remove(n);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        Iterator iterator = intKeyIntValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            int n3 = this.useMap.get(n2, 1) - 1;
            if (n3 == 0) {
                CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n2);
                if (compiledStatement != null) {
                    int n4 = compiledStatement.schemaHsqlName.hashCode();
                    IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n4);
                    String string = (String)this.sqlLookup.remove(n2);
                    intValueHashMap.remove(string);
                }
                this.useMap.remove(n2);
                continue;
            }
            this.useMap.put(n2, n3);
        }
    }

    synchronized CompiledStatement compile(Session session, String string) throws Throwable {
        int n = this.getStatementID(session.currentSchema, string);
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n);
        if (compiledStatement == null || !compiledStatement.isValid || !session.isAdmin()) {
            compiledStatement = this.compileSql(session, string, session.currentSchema.name);
            n = this.registerStatement(n, compiledStatement);
        }
        this.linkSession(n, session.getId());
        return compiledStatement;
    }

    private CompiledStatement compileSql(Session session, String string, String string2) throws Throwable {
        Session session2 = this.database.sessionManager.getSysSession(string2, session.getUser());
        return session2.sqlCompileStatement(string);
    }
}

