/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.enterprise.ClientSideSessionUtils;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.PlDotIni;
import ca.sqlpower.sql.SPDataSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class DataSourceCollectionUpdater
implements DatabaseListChangeListener,
PropertyChangeListener,
UndoableEditListener {
    protected final ProjectLocation projectLocation;
    protected boolean postingProperties = false;
    protected final ResponseHandler<Void> responseHandler = new ResponseHandler<Void>(){

        public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ClientProtocolException("Failed to create/update data source on server. Reason:\n" + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            return null;
        }
    };

    public DataSourceCollectionUpdater(ProjectLocation projectLocation) {
        this.projectLocation = projectLocation;
    }

    public abstract HttpClient getHttpClient();

    public void attach(DataSourceCollection<JDBCDataSource> dsCollection) {
        dsCollection.addDatabaseListChangeListener(this);
        dsCollection.addUndoableEditListener(this);
        for (JDBCDataSourceType jdst : dsCollection.getDataSourceTypes()) {
            jdst.addPropertyChangeListener(this);
        }
        for (JDBCDataSource ds : dsCollection.getConnections()) {
            ds.addPropertyChangeListener(this);
        }
    }

    public void detach(DataSourceCollection<JDBCDataSource> dsCollection) {
        dsCollection.removeDatabaseListChangeListener(this);
        dsCollection.removeUndoableEditListener(this);
        for (JDBCDataSourceType jdst : dsCollection.getDataSourceTypes()) {
            jdst.removePropertyChangeListener(this);
        }
        for (JDBCDataSource ds : dsCollection.getConnections()) {
            ds.removePropertyChangeListener(this);
        }
    }

    @Override
    public void databaseAdded(DatabaseListChangeEvent e) {
        SPDataSource source = e.getDataSource();
        source.addPropertyChangeListener(this);
        ArrayList<NameValuePair> properties = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> ent : source.getPropertiesMap().entrySet()) {
            properties.add((NameValuePair)new BasicNameValuePair(ent.getKey(), ent.getValue()));
        }
        this.databaseAdded(e, source, properties);
    }

    public void databaseAdded(DatabaseListChangeEvent e, SPDataSource source, List<NameValuePair> properties) {
        if (source instanceof JDBCDataSource) {
            this.postJDBCDataSourceProperties((JDBCDataSource)source, properties);
        }
    }

    @Override
    public void databaseRemoved(DatabaseListChangeEvent e) {
        HttpClient httpClient = this.getHttpClient();
        try {
            SPDataSource removedDS = e.getDataSource();
            HttpDelete request = new HttpDelete(this.jdbcDataSourceURI(removedDS));
            httpClient.execute((HttpUriRequest)request, this.responseHandler);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    protected URI jdbcDataSourceTypeURI(JDBCDataSourceType jdst) throws URISyntaxException {
        return ClientSideSessionUtils.getServerURI(this.projectLocation.getServiceInfo(), "/rest/data-sources/type/" + jdst.getName());
    }

    protected URI jdbcDataSourceURI(SPDataSource jds) throws URISyntaxException {
        if (!(jds instanceof JDBCDataSource)) {
            throw new IllegalStateException("DataSource must be an instance of JDBCDataSource");
        }
        return ClientSideSessionUtils.getServerURI(this.projectLocation.getServiceInfo(), "/rest/data-sources/JDBCDataSource/" + jds.getName());
    }

    protected void postJDBCDataSourceProperties(JDBCDataSource ds, List<NameValuePair> properties) {
        if (this.postingProperties) {
            return;
        }
        HttpClient httpClient = this.getHttpClient();
        try {
            URI jdbcDataSourceURI = this.jdbcDataSourceURI(ds);
            try {
                HttpPost request = new HttpPost(jdbcDataSourceURI);
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(properties));
                httpClient.execute((HttpUriRequest)request, this.responseHandler);
            }
            catch (IOException ex) {
                throw new RuntimeException("Server request failed at " + jdbcDataSourceURI, ex);
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    protected void postJDBCDataSourceTypeProperties(JDBCDataSourceType jdst, List<NameValuePair> properties) {
        if (this.postingProperties) {
            return;
        }
        HttpClient httpClient = this.getHttpClient();
        try {
            HttpPost request = new HttpPost(this.jdbcDataSourceTypeURI(jdst));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(properties));
            httpClient.execute((HttpUriRequest)request, this.responseHandler);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        JDBCDataSourceType jdst;
        if (e.getEdit() instanceof PlDotIni.AddDSTypeUndoableEdit) {
            jdst = ((PlDotIni.AddDSTypeUndoableEdit)e.getEdit()).getType();
            jdst.addPropertyChangeListener(this);
            ArrayList<NameValuePair> properties = new ArrayList<NameValuePair>();
            for (String name : jdst.getPropertyNames()) {
                properties.add((NameValuePair)new BasicNameValuePair(name, jdst.getProperty(name)));
            }
            this.postJDBCDataSourceTypeProperties(jdst, properties);
        }
        if (e.getEdit() instanceof PlDotIni.RemoveDSTypeUndoableEdit) {
            jdst = ((PlDotIni.RemoveDSTypeUndoableEdit)e.getEdit()).getType();
            jdst.removePropertyChangeListener(this);
            this.removeJDBCDataSourceType(jdst);
        }
    }

    public void removeJDBCDataSourceType(JDBCDataSourceType jdst) {
        HttpClient httpClient = this.getHttpClient();
        try {
            HttpDelete request = new HttpDelete(this.jdbcDataSourceTypeURI(jdst));
            httpClient.execute((HttpUriRequest)request, this.responseHandler);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ArrayList<NameValuePair> properties;
        Object source = evt.getSource();
        if (source instanceof SPDataSource) {
            SPDataSource ds = (SPDataSource)source;
            ds.addPropertyChangeListener(this);
            properties = new ArrayList<NameValuePair>();
            for (Map.Entry entry : ds.getPropertiesMap().entrySet()) {
                properties.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
            this.propertyChange(evt, ds, properties);
        }
        if (source instanceof JDBCDataSourceType) {
            JDBCDataSourceType jdst = (JDBCDataSourceType)source;
            jdst.addPropertyChangeListener(this);
            properties = new ArrayList();
            for (String string : jdst.getPropertyNames()) {
                properties.add((NameValuePair)new BasicNameValuePair(string, jdst.getProperty(string)));
            }
            this.postJDBCDataSourceTypeProperties(jdst, properties);
        }
    }

    public void propertyChange(PropertyChangeEvent evt, SPDataSource ds, List<NameValuePair> properties) {
        if (ds instanceof JDBCDataSource) {
            this.postJDBCDataSourceProperties((JDBCDataSource)ds, properties);
        }
    }
}

