/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util.reservoir;

import ca.sqlpower.util.reservoir.ReservoirDataException;
import ca.sqlpower.util.reservoir.ReservoirDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCReserviorDataSource
implements ReservoirDataSource<Object[]> {
    private final Statement stmt;
    private final ResultSet rs;
    private final ResultSetMetaData rsmd;
    private final int colCount;
    private int rowCount;

    public JDBCReserviorDataSource(Connection con, String query) throws SQLException {
        con.setAutoCommit(false);
        this.stmt = con.createStatement(1004, 1007);
        this.stmt.setFetchSize(1);
        this.rs = this.stmt.executeQuery(query);
        this.rsmd = this.rs.getMetaData();
        this.colCount = this.rsmd.getColumnCount();
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public boolean hasNext() throws ReservoirDataException {
        try {
            return !this.rs.isLast() && (this.rs.getRow() != 0 || this.rs.isBeforeFirst());
        }
        catch (SQLException e) {
            throw new ReservoirDataException(e);
        }
    }

    @Override
    public Object[] readNextRecord() throws ReservoirDataException {
        try {
            boolean hasNext = this.rs.next();
            if (!hasNext) {
                throw new ReservoirDataException("Attempted to read past last record");
            }
            ++this.rowCount;
            Object[] rowValues = new Object[this.colCount];
            for (int i = 0; i < this.colCount; ++i) {
                rowValues[i] = this.rs.getObject(i + 1);
            }
            return rowValues;
        }
        catch (SQLException e) {
            throw new ReservoirDataException(e);
        }
    }

    @Override
    public void skipRecords(int count) throws ReservoirDataException {
        try {
            boolean onValidRow = this.rs.relative(count);
            this.rowCount = onValidRow ? this.rs.getRow() : this.rs.getRow() - 1;
        }
        catch (SQLException e) {
            throw new ReservoirDataException(e);
        }
    }

    Statement getStatement() {
        return this.stmt;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

