/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.diff.ArchitectDiffException;
import ca.sqlpower.architect.diff.SQLIndexComparator;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.architect.diff.SQLRelationshipComparator;
import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffType;
import ca.sqlpower.diff.PropertyChange;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectUUIDComparator;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.Monitorable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CompareSQL
implements Monitorable {
    private static final char LEFT_RIGHT_ARROW = '\u2194';
    private static final char LEFT_ARROW = '\u2190';
    private static final char RIGHT_ARROW = '\u2192';
    private static final Logger logger = Logger.getLogger(CompareSQL.class);
    static final Comparator<SQLObject> nameComparator = new SQLObjectComparator();
    static final Comparator<SQLObject> uuidComparator = new SPObjectUUIDComparator();
    private TreeSet<SQLTable> sourceTableSet;
    private TreeSet<SQLTable> targetTableSet;
    private Integer jobSize;
    private int progress;
    private boolean finished;
    private boolean cancelled;
    List<DiffChunk<SQLObject>> results;
    private String progressMessage;
    private boolean compareIndex;
    private boolean started;
    private boolean suppressSimilarities;
    private boolean useUUID;

    public CompareSQL(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables, boolean suppressSimilarities) throws ArchitectDiffException {
        this(sourceTables, targetTables, suppressSimilarities, false);
    }

    public CompareSQL(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables, boolean suppressSimilarities, boolean useUUID) throws ArchitectDiffException {
        boolean sourceValid = true;
        boolean targetValid = true;
        this.useUUID = useUUID;
        this.sourceTableSet = new TreeSet<SQLObject>(this.getObjectComparator());
        this.sourceTableSet.addAll(sourceTables);
        this.targetTableSet = new TreeSet<SQLObject>(this.getObjectComparator());
        this.targetTableSet.addAll(targetTables);
        this.suppressSimilarities = suppressSimilarities;
        if (this.sourceTableSet.size() != sourceTables.size()) {
            sourceValid = false;
        }
        if (this.targetTableSet.size() != targetTables.size()) {
            targetValid = false;
        }
        if (!sourceValid || !targetValid) {
            String error = !sourceValid && !targetValid ? "Your source and target both have tables with duplicate names." : (!sourceValid ? "Your source has tables with the same name as each other." : "Your target has tables with the same name as each other.");
            throw new ArchitectDiffException(error);
        }
        this.results = new ArrayList<DiffChunk<SQLObject>>();
        this.setProgress(0);
        this.setJobSize(this.targetTableSet.size() * 2 + this.sourceTableSet.size() * 2);
        this.setFinished(false);
        this.setStarted(false);
    }

    public List<DiffChunk<SQLObject>> generateTableDiffs() throws SQLObjectException {
        return this.generateTableDiffs(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiffChunk<SQLObject>> generateTableDiffs(ArchitectSession session) throws SQLObjectException {
        this.setStarted(true);
        this.setFinished(false);
        try {
            SQLTable targetTable;
            boolean targetContinue;
            SQLTable sourceTable;
            boolean sourceContinue;
            Iterator<SQLTable> sourceIter = this.sourceTableSet.iterator();
            Iterator<SQLTable> targetIter = this.targetTableSet.iterator();
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceTable = sourceIter.next();
                sourceTable.populate();
            } else {
                sourceContinue = false;
                sourceTable = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetTable = targetIter.next();
                targetTable.populate();
            } else {
                targetContinue = false;
                targetTable = null;
            }
            while (sourceContinue && targetContinue && !this.isCancelled()) {
                logger.debug((Object)("Generating table diffs for " + sourceTable.getName()));
                if (session != null) {
                    ArchitectUtils.setUpstreamTypesInTable(sourceTable, session);
                    ArchitectUtils.setUpstreamTypesInTable(targetTable, session);
                }
                DiffChunk chunk = null;
                int compareResult = this.getObjectComparator().compare((SQLObject)sourceTable, (SQLObject)targetTable);
                if (compareResult < 0) {
                    chunk = new DiffChunk((Object)sourceTable, DiffType.LEFTONLY);
                    this.incProgress(1, (SQLObject)sourceTable, (SQLObject)targetTable);
                    if (sourceIter.hasNext()) {
                        sourceTable = sourceIter.next();
                        sourceTable.populate();
                    } else {
                        sourceContinue = false;
                    }
                }
                if (compareResult > 0) {
                    chunk = new DiffChunk((Object)targetTable, DiffType.RIGHTONLY);
                    this.incProgress(1, (SQLObject)sourceTable, (SQLObject)targetTable);
                    if (targetIter.hasNext()) {
                        targetTable = targetIter.next();
                        targetTable.populate();
                    } else {
                        targetContinue = false;
                    }
                }
                if (compareResult == 0) {
                    List<PropertyChange> changes = this.generatePropertyChanges((SQLObject)sourceTable, (SQLObject)targetTable);
                    if (changes.size() > 0) {
                        if (nameComparator.compare((SQLObject)sourceTable, (SQLObject)targetTable) != 0) {
                            chunk = new DiffChunk((Object)targetTable, DiffType.NAME_CHANGED);
                            chunk.setOriginalData((Object)sourceTable);
                        } else {
                            chunk = !StringUtils.equals((String)sourceTable.getRemarks(), (String)targetTable.getRemarks()) ? new DiffChunk((Object)sourceTable, DiffType.SQL_MODIFIED) : new DiffChunk((Object)sourceTable, DiffType.MODIFIED);
                        }
                        for (PropertyChange change : changes) {
                            chunk.addPropertyChange(change);
                        }
                    } else {
                        chunk = new DiffChunk((Object)sourceTable, DiffType.SAME);
                    }
                    this.incProgress(1, (SQLObject)sourceTable, (SQLObject)targetTable);
                    List<DiffChunk<SQLObject>> columns = this.generateColumnDiffs(sourceTable, targetTable);
                    if (chunk.getType() != DiffType.SAME || !this.suppressSimilarities || columns.size() > 0) {
                        this.results.add((DiffChunk<SQLObject>)chunk);
                        this.results.addAll(columns);
                    }
                    if (!targetIter.hasNext() && !sourceIter.hasNext()) {
                        targetContinue = false;
                        sourceContinue = false;
                    }
                    if (targetIter.hasNext()) {
                        targetTable = targetIter.next();
                        targetTable.populate();
                    } else {
                        targetContinue = false;
                    }
                    if (sourceIter.hasNext()) {
                        sourceTable = sourceIter.next();
                        sourceTable.populate();
                        continue;
                    }
                    sourceContinue = false;
                    continue;
                }
                this.results.add((DiffChunk<SQLObject>)chunk);
            }
            while (sourceContinue && !this.isCancelled()) {
                if (session != null) {
                    ArchitectUtils.setUpstreamTypesInTable(sourceTable, session);
                }
                this.results.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceTable, DiffType.LEFTONLY));
                this.incProgress(1, (SQLObject)sourceTable, null);
                if (sourceIter.hasNext()) {
                    sourceTable = sourceIter.next();
                    sourceTable.populate();
                    continue;
                }
                sourceContinue = false;
            }
            while (targetContinue && !this.isCancelled()) {
                if (session != null) {
                    ArchitectUtils.setUpstreamTypesInTable(targetTable, session);
                }
                this.results.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetTable, DiffType.RIGHTONLY));
                this.incProgress(1, null, (SQLObject)targetTable);
                if (targetIter.hasNext()) {
                    targetTable = targetIter.next();
                    targetTable.populate();
                    continue;
                }
                targetContinue = false;
            }
            this.results.addAll(this.generateRelationshipDiffs(this.sourceTableSet, this.targetTableSet));
            if (this.compareIndex) {
                this.results.addAll(this.generateIndexDiffs(this.sourceTableSet, this.targetTableSet));
            }
        }
        finally {
            this.setJobSize(null);
            this.setFinished(true);
        }
        return this.results;
    }

    private List<DiffChunk<SQLObject>> generateRelationshipDiffs(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables) throws SQLObjectException {
        SQLRelationship targetRel;
        boolean targetContinue;
        SQLRelationship sourceRel;
        boolean sourceContinue;
        SQLRelationshipComparator relComparator = new SQLRelationshipComparator(this.useUUID);
        TreeSet<SQLRelationship> sourceRels = new TreeSet<SQLRelationship>(relComparator);
        TreeSet<SQLRelationship> targetRels = new TreeSet<SQLRelationship>(relComparator);
        for (SQLTable t : sourceTables) {
            this.incProgress(1, (SQLObject)t, null);
            sourceRels.addAll(SQLRelationship.getExportedKeys((List)t.getImportedKeys()));
        }
        for (SQLTable t : targetTables) {
            this.incProgress(1, null, (SQLObject)t);
            targetRels.addAll(SQLRelationship.getExportedKeys((List)t.getImportedKeys()));
        }
        logger.debug((Object)("Source relationships: " + sourceRels));
        logger.debug((Object)("Target relationships: " + targetRels));
        ArrayList<DiffChunk<SQLObject>> diffs = new ArrayList<DiffChunk<SQLObject>>();
        Iterator sourceIter = sourceRels.iterator();
        Iterator targetIter = targetRels.iterator();
        if (sourceIter.hasNext()) {
            sourceContinue = true;
            sourceRel = (SQLRelationship)sourceIter.next();
        } else {
            sourceContinue = false;
            sourceRel = null;
        }
        if (targetIter.hasNext()) {
            targetContinue = true;
            targetRel = (SQLRelationship)targetIter.next();
        } else {
            targetContinue = false;
            targetRel = null;
        }
        while (sourceContinue && targetContinue) {
            int compareResult = relComparator.compare(sourceRel, targetRel);
            if (compareResult < 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceRel, DiffType.LEFTONLY));
                if (sourceIter.hasNext()) {
                    sourceRel = (SQLRelationship)sourceIter.next();
                } else {
                    sourceContinue = false;
                }
            }
            if (compareResult > 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetRel, DiffType.RIGHTONLY));
                if (targetIter.hasNext()) {
                    targetRel = (SQLRelationship)targetIter.next();
                } else {
                    targetContinue = false;
                }
            }
            if (compareResult != 0) continue;
            List<PropertyChange> changes = this.generatePropertyChanges((SQLObject)sourceRel, (SQLObject)targetRel);
            if (changes.size() > 0) {
                DiffChunk chunk = null;
                if (nameComparator.compare((SQLObject)sourceRel, (SQLObject)targetRel) != 0) {
                    chunk = new DiffChunk((Object)targetRel, DiffType.NAME_CHANGED);
                    chunk.setOriginalData((Object)sourceRel);
                } else {
                    chunk = new DiffChunk((Object)sourceRel, DiffType.MODIFIED);
                }
                for (PropertyChange change : changes) {
                    chunk.addPropertyChange(change);
                }
                diffs.add((DiffChunk<SQLObject>)chunk);
            } else if (!this.suppressSimilarities) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceRel, DiffType.SAME));
            }
            if (!targetIter.hasNext() && !sourceIter.hasNext()) {
                targetContinue = false;
                sourceContinue = false;
            }
            if (targetIter.hasNext()) {
                targetRel = (SQLRelationship)targetIter.next();
            } else {
                targetContinue = false;
            }
            if (sourceIter.hasNext()) {
                sourceRel = (SQLRelationship)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (sourceContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceRel, DiffType.LEFTONLY));
            if (sourceIter.hasNext()) {
                sourceRel = (SQLRelationship)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (targetContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetRel, DiffType.RIGHTONLY));
            if (targetIter.hasNext()) {
                targetRel = (SQLRelationship)targetIter.next();
                continue;
            }
            targetContinue = false;
        }
        return diffs;
    }

    private List<DiffChunk<SQLObject>> generateIndexDiffs(Collection<SQLTable> sourceTables, Collection<SQLTable> targetTables) throws SQLObjectException {
        SQLIndex targetInd;
        boolean targetContinue;
        SQLIndex sourceInd;
        boolean sourceContinue;
        SQLIndexComparator indComparator = new SQLIndexComparator(this.useUUID);
        TreeSet<SQLIndex> sourceInds = new TreeSet<SQLIndex>(indComparator);
        TreeSet<SQLIndex> targetInds = new TreeSet<SQLIndex>(indComparator);
        for (SQLTable t : sourceTables) {
            this.incProgress(1, (SQLObject)t, null);
            if (t.getIndices() == null) continue;
            sourceInds.addAll(t.getIndices());
        }
        for (SQLTable t : targetTables) {
            this.incProgress(1, null, (SQLObject)t);
            if (t.getIndices() == null) continue;
            targetInds.addAll(t.getIndices());
        }
        logger.debug((Object)("Source indices: " + sourceInds));
        logger.debug((Object)("Target indices: " + targetInds));
        ArrayList<DiffChunk<SQLObject>> diffs = new ArrayList<DiffChunk<SQLObject>>();
        Iterator sourceIter = sourceInds.iterator();
        Iterator targetIter = targetInds.iterator();
        if (sourceIter.hasNext()) {
            sourceContinue = true;
            sourceInd = (SQLIndex)sourceIter.next();
        } else {
            sourceContinue = false;
            sourceInd = null;
        }
        if (targetIter.hasNext()) {
            targetContinue = true;
            targetInd = (SQLIndex)targetIter.next();
        } else {
            targetContinue = false;
            targetInd = null;
        }
        while (sourceContinue && targetContinue) {
            int compareResult = indComparator.compare(sourceInd, targetInd);
            if (compareResult < 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceInd, DiffType.LEFTONLY));
                if (sourceIter.hasNext()) {
                    sourceInd = (SQLIndex)sourceIter.next();
                } else {
                    sourceContinue = false;
                }
            }
            if (compareResult > 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetInd, DiffType.RIGHTONLY));
                if (targetIter.hasNext()) {
                    targetInd = (SQLIndex)targetIter.next();
                } else {
                    targetContinue = false;
                }
            }
            if (compareResult != 0) continue;
            List<PropertyChange> changes = this.generatePropertyChanges((SQLObject)sourceInd, (SQLObject)targetInd);
            if (changes.size() > 0) {
                DiffChunk chunk = null;
                if (nameComparator.compare((SQLObject)sourceInd, (SQLObject)targetInd) != 0) {
                    chunk = new DiffChunk((Object)targetInd, DiffType.NAME_CHANGED);
                    chunk.setOriginalData((Object)sourceInd);
                } else {
                    chunk = new DiffChunk((Object)sourceInd, DiffType.MODIFIED);
                }
                for (PropertyChange change : changes) {
                    chunk.addPropertyChange(change);
                }
                diffs.add((DiffChunk<SQLObject>)chunk);
            } else if (!this.suppressSimilarities) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceInd, DiffType.SAME));
            }
            if (!targetIter.hasNext() && !sourceIter.hasNext()) {
                targetContinue = false;
                sourceContinue = false;
            }
            if (targetIter.hasNext()) {
                targetInd = (SQLIndex)targetIter.next();
            }
            if (sourceIter.hasNext()) {
                sourceInd = (SQLIndex)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (sourceContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceInd, DiffType.LEFTONLY));
            if (sourceIter.hasNext()) {
                sourceInd = (SQLIndex)sourceIter.next();
                continue;
            }
            sourceContinue = false;
        }
        while (targetContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetInd, DiffType.RIGHTONLY));
            if (targetIter.hasNext()) {
                targetInd = (SQLIndex)targetIter.next();
                continue;
            }
            targetContinue = false;
        }
        return diffs;
    }

    private List<DiffChunk<SQLObject>> generateColumnDiffs(SQLTable sourceTable, SQLTable targetTable) throws SQLObjectException {
        boolean keyChangeFlag = false;
        TreeSet<SQLObject> sourceColumnList = new TreeSet<SQLObject>(this.getObjectComparator());
        TreeSet<SQLObject> targetColumnList = new TreeSet<SQLObject>(this.getObjectComparator());
        boolean sourceColContinue = false;
        boolean targetColContinue = false;
        Iterator<SQLObject> sourceColIter = null;
        Iterator<SQLObject> targetColIter = null;
        SQLColumn sourceColumn = null;
        SQLColumn targetColumn = null;
        ArrayList<DiffChunk<SQLObject>> diffs = new ArrayList<DiffChunk<SQLObject>>();
        if (sourceTable != null) {
            sourceColumnList.addAll(sourceTable.getColumns());
        }
        if (targetTable != null) {
            targetColumnList.addAll(targetTable.getColumns());
        }
        if (sourceColumnList.size() == 0) {
            sourceColumnList = null;
            sourceColContinue = false;
        } else {
            sourceColIter = sourceColumnList.iterator();
            sourceColumn = (SQLColumn)sourceColIter.next();
            sourceColContinue = true;
        }
        if (targetColumnList.size() == 0) {
            targetColumnList = null;
            targetColContinue = false;
        } else {
            targetColIter = targetColumnList.iterator();
            targetColumn = (SQLColumn)targetColIter.next();
            targetColContinue = true;
        }
        while (sourceColContinue && targetColContinue) {
            List<PropertyChange> changes;
            int compareResult = this.getObjectComparator().compare((SQLObject)sourceColumn, (SQLObject)targetColumn);
            if (compareResult < 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceColumn, DiffType.LEFTONLY));
                logger.debug((Object)("The source column is " + sourceColumn));
                if (sourceColumn.isPrimaryKey()) {
                    keyChangeFlag = true;
                }
                if (sourceColIter.hasNext()) {
                    sourceColumn = (SQLColumn)sourceColIter.next();
                } else {
                    sourceColContinue = false;
                }
            }
            if (compareResult > 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetColumn, DiffType.RIGHTONLY));
                logger.debug((Object)("The target column is " + targetColumn));
                if (targetColumn.isPrimaryKey()) {
                    keyChangeFlag = true;
                }
                if (targetColIter.hasNext()) {
                    targetColumn = (SQLColumn)targetColIter.next();
                } else {
                    targetColContinue = false;
                }
            }
            if (compareResult != 0) continue;
            if (targetColumn.isPrimaryKey() != sourceColumn.isPrimaryKey()) {
                keyChangeFlag = true;
            }
            if ((changes = this.generatePropertyChanges((SQLObject)sourceColumn, (SQLObject)targetColumn)).size() > 0) {
                DiffChunk chunk = null;
                if (nameComparator.compare((SQLObject)sourceColumn, (SQLObject)targetColumn) != 0) {
                    chunk = new DiffChunk((Object)targetColumn, DiffType.NAME_CHANGED);
                    chunk.setOriginalData((Object)sourceColumn);
                } else if (ArchitectUtils.columnsDiffer(targetColumn, sourceColumn)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Column " + sourceColumn.getName() + " differs!"));
                        logger.debug((Object)String.format("  Type:      %10d %10d", targetColumn.getType(), sourceColumn.getType()));
                        logger.debug((Object)String.format("  Precision: %10d %10d", targetColumn.getPrecision(), sourceColumn.getPrecision()));
                        logger.debug((Object)String.format("  Scale:     %10d %10d", targetColumn.getScale(), sourceColumn.getScale()));
                        logger.debug((Object)String.format("  Nullable:  %10d %10d", targetColumn.getNullable(), sourceColumn.getNullable()));
                    }
                    chunk = new DiffChunk((Object)targetColumn, DiffType.SQL_MODIFIED);
                } else {
                    chunk = new DiffChunk((Object)targetColumn, DiffType.MODIFIED);
                }
                for (PropertyChange change : changes) {
                    chunk.addPropertyChange(change);
                }
                diffs.add((DiffChunk<SQLObject>)chunk);
            } else if (!this.suppressSimilarities) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceColumn, DiffType.SAME));
            }
            if (targetColIter.hasNext()) {
                targetColumn = (SQLColumn)targetColIter.next();
            } else {
                targetColContinue = false;
            }
            if (sourceColIter.hasNext()) {
                sourceColumn = (SQLColumn)sourceColIter.next();
                continue;
            }
            sourceColContinue = false;
        }
        while (sourceColContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceColumn, DiffType.LEFTONLY));
            if (sourceColIter.hasNext()) {
                sourceColumn = (SQLColumn)sourceColIter.next();
                continue;
            }
            sourceColContinue = false;
        }
        while (targetColContinue) {
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetColumn, DiffType.RIGHTONLY));
            if (targetColIter.hasNext()) {
                targetColumn = (SQLColumn)targetColIter.next();
                continue;
            }
            targetColContinue = false;
        }
        if (keyChangeFlag) {
            if (sourceTable.getPkSize() > 0) {
                diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)sourceTable, DiffType.DROP_KEY));
            }
            diffs.add((DiffChunk<SQLObject>)new DiffChunk((Object)targetTable, DiffType.KEY_CHANGED));
        }
        return diffs;
    }

    private List<PropertyChange> generatePropertyChanges(SQLObject sourceObject, SQLObject targetObject) throws SQLObjectException {
        ArrayList<PropertyChange> changes = new ArrayList<PropertyChange>();
        try {
            SessionPersisterSuperConverter converter = new SessionPersisterSuperConverter(null, (SPObject)sourceObject);
            Map sourceProperties = PersisterUtils.getInterestingProperties((SQLObject)sourceObject, (SessionPersisterSuperConverter)converter);
            converter = new SessionPersisterSuperConverter(null, (SPObject)targetObject);
            Map targetProperties = PersisterUtils.getInterestingProperties((SQLObject)targetObject, (SessionPersisterSuperConverter)converter);
            for (String propertyName : sourceProperties.keySet()) {
                String oldValue = String.valueOf(sourceProperties.get(propertyName));
                String newValue = String.valueOf(targetProperties.get(propertyName));
                if (oldValue.equals("")) {
                    oldValue = "null";
                }
                if (newValue.equals("")) {
                    newValue = "null";
                }
                if (oldValue.equals(newValue)) continue;
                logger.debug((Object)(propertyName + "differs"));
                changes.add(new PropertyChange(propertyName, oldValue, newValue));
            }
        }
        catch (Exception e) {
            throw new SQLObjectException("Error generating property diffs", (Throwable)e);
        }
        return changes;
    }

    private Comparator<SQLObject> getObjectComparator() {
        return this.useUUID ? uuidComparator : nameComparator;
    }

    public synchronized Integer getJobSize() {
        return this.jobSize;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized boolean hasStarted() {
        return this.started;
    }

    private synchronized void setStarted(boolean started) {
        this.started = started;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized String getMessage() {
        return this.progressMessage;
    }

    public synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setJobSize(Integer jobSize) {
        this.jobSize = jobSize;
    }

    private synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    private synchronized void incProgress(int amount, SQLObject lhs, SQLObject rhs) {
        this.progressMessage = lhs != null && rhs != null ? lhs + " " + '\u2194' + " " + rhs : (lhs != null ? "\u2190 " + lhs.getName() : (rhs != null ? "\u2192 " + rhs.getName() : null));
        this.progress += amount;
    }

    public synchronized void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isCompareIndices() {
        return this.compareIndex;
    }

    public void setCompareIndices(boolean compareIndices) {
        this.compareIndex = compareIndices;
    }
}

