/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap.undo;

import ca.sqlpower.object.SPChildEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class OLAPChildEdit
extends AbstractUndoableEdit {
    private final SPChildEvent event;
    private final boolean removal;

    public OLAPChildEdit(SPChildEvent event, boolean removal) {
        if (event == null) {
            throw new NullPointerException("Null event");
        }
        if (event.getSource() == null) {
            throw new NullPointerException("Null source");
        }
        if (event.getChild() == null) {
            throw new NullPointerException("Null child");
        }
        if (event.getIndex() < 0 || event.getIndex() > event.getSource().getChildren().size()) {
            throw new IllegalArgumentException("Impossible add/remove index: " + event.getIndex());
        }
        this.event = event;
        this.removal = removal;
    }

    @Override
    public String getPresentationName() {
        if (this.removal) {
            return "Remove child from " + this.event.getSource().getName();
        }
        return "Add child to " + this.event.getSource().getName();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.removal) {
            this.removeChild();
        } else {
            this.addChild();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.removal) {
            this.addChild();
        } else {
            this.removeChild();
        }
    }

    private void addChild() {
        this.event.getSource().addChild(this.event.getChild(), this.event.getIndex());
    }

    private void removeChild() {
        try {
            this.event.getSource().removeChild(this.event.getChild());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        String verb = this.removal ? "Remove" : "Add";
        String preposition = this.removal ? " from " : " to ";
        return verb + " child " + this.event.getChild().getName() + preposition + this.event.getSource().getName();
    }
}

