/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.etl.ExportCSV;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.MappingReport;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class VisualMappingReportAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(VisualMappingReportAction.class);
    private final ArchitectFrame frame;

    public VisualMappingReportAction(ArchitectFrame frame) {
        super(frame, Messages.getString("VisualMappingReportAction.name"), Messages.getString("VisualMappingReportAction.description"));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ArrayList<Object> selectedTables;
            if (this.getSession() == null) {
                return;
            }
            ArrayList<TablePane> selectedTablePanes = new ArrayList<TablePane>();
            for (ContainerPane<?, ?> cp : this.getPlaypen().getSelectedContainers()) {
                if (!(cp instanceof TablePane)) continue;
                selectedTablePanes.add((TablePane)cp);
            }
            if (selectedTablePanes.size() == 0) {
                selectedTables = new ArrayList<SQLTable>(this.getPlaypen().getTables());
            } else if (0 == JOptionPane.showConfirmDialog(this.frame, Messages.getString("VisualMappingReportAction.viewOnlySelectedTables", String.valueOf(selectedTablePanes.size())), Messages.getString("VisualMappingReportAction.viewOnlySelectedTablesDialogTitle"), 0)) {
                selectedTables = new ArrayList();
                for (TablePane tp : selectedTablePanes) {
                    selectedTables.add(tp.getModel());
                }
            } else {
                selectedTables = new ArrayList<SQLTable>(this.getPlaypen().getTables());
            }
            final MappingReport mr = new MappingReport(this.getSession(), selectedTables);
            final JFrame f = new JFrame(Messages.getString("VisualMappingReportAction.mappingReportDialogTitle"));
            f.setIconImage(ASUtils.getFrameIconImage());
            JPanel mrPanel = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    try {
                        mr.drawHighLevelReport((Graphics2D)g, null);
                    }
                    catch (SQLObjectException e1) {
                        logger.error((Object)"ArchitectException while generating mapping diagram", (Throwable)e1);
                        ASUtils.showExceptionDialogNoReport(Messages.getString("VisualMappingReportAction.couldNotGenerateMappingDiagram"), e1);
                    }
                }
            };
            mrPanel.setDoubleBuffered(true);
            mrPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            mrPanel.setPreferredSize(mr.getRequiredSize());
            mrPanel.setOpaque(true);
            mrPanel.setBackground(Color.WHITE);
            ButtonBarBuilder buttonBar = new ButtonBarBuilder();
            JButton csv = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputStreamWriter output = null;
                    try {
                        ExportCSV export = new ExportCSV(selectedTables);
                        File file = null;
                        JFileChooser fileDialog = new JFileChooser(VisualMappingReportAction.this.getSession().getRecentMenu().getMostRecentFile());
                        fileDialog.setSelectedFile(new File("map.csv"));
                        if (fileDialog.showSaveDialog(f) != 0) {
                            return;
                        }
                        file = fileDialog.getSelectedFile();
                        output = new FileWriter(file);
                        output.write(export.getCSVMapping());
                        output.flush();
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (SQLObjectException e1) {
                        throw new SQLObjectRuntimeException(e1);
                    }
                    finally {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException e1) {
                                logger.error((Object)"IO Error", (Throwable)e1);
                            }
                        }
                    }
                }
            });
            csv.setText(Messages.getString("VisualMappingReportAction.exportCSVOption"));
            buttonBar.addGriddedGrowing((JComponent)csv);
            JButton close = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    f.dispose();
                }
            });
            close.setText(Messages.getString("VisualMappingReportAction.closeOption"));
            buttonBar.addRelatedGap();
            buttonBar.addGriddedGrowing((JComponent)close);
            JPanel basePane = new JPanel(new BorderLayout(5, 5));
            basePane.add((Component)new JScrollPane(mrPanel), "Center");
            basePane.add((Component)buttonBar.getPanel(), "South");
            f.setContentPane(basePane);
            f.pack();
            f.setLocationRelativeTo(this.frame);
            f.setVisible(true);
        }
        catch (SQLObjectException e1) {
            throw new SQLObjectRuntimeException(e1);
        }
    }
}

