/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class CreateOLAPChildAction<P extends OLAPPane<?, ?>, C extends OLAPObject>
extends AbstractArchitectAction {
    private final String friendlyParentName;
    private final String friendlyChildName;
    private final Class<P> paneClass;

    public CreateOLAPChildAction(ArchitectSwingSession session, PlayPen olapPlayPen, String friendlyChildName, Class<P> paneClass, String friendlyParentName, char accelKey, Icon icon) {
        super(session, olapPlayPen, "New " + friendlyChildName + "...", null, icon);
        this.friendlyChildName = friendlyChildName;
        this.paneClass = paneClass;
        this.friendlyParentName = friendlyParentName;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelKey));
        PlayPenWatcher ppw = new PlayPenWatcher();
        this.getPlaypen().addSelectionListener(ppw);
        this.updateActionState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<PlayPenComponent> selectedItems = this.getPlaypen().getSelectedItems();
        final OLAPPane pane = (OLAPPane)this.paneClass.cast(selectedItems.get(0));
        ((OLAPObject)((Object)pane.getModel())).begin("Add " + this.friendlyChildName);
        final C child = this.addNewChild(pane);
        final DataEntryPanel mep = this.createDataEntryPanel(child);
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean applied = mep.applyChanges();
                ((OLAPObject)((Object)pane.getModel())).commit();
                return applied;
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                child.getParent().removeChild((SPObject)child);
                ((OLAPObject)((Object)pane.getModel())).commit();
                return true;
            }
        };
        JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)mep, (Component)SwingUtilities.getWindowAncestor(this.getPlaypen()), (String)(this.friendlyChildName + " Properties"), (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)okCall, (Callable)cancelCall);
        d.setLocationRelativeTo(this.getPlaypen());
        d.setVisible(true);
    }

    protected abstract C addNewChild(P var1);

    protected abstract DataEntryPanel createDataEntryPanel(C var1);

    protected void updateActionState() {
        String description;
        List<PlayPenComponent> selectedItems = this.getPlaypen().getSelectedItems();
        if (selectedItems.size() == 1 && this.paneClass.isInstance(selectedItems.get(0))) {
            this.setEnabled(true);
            description = "Add " + this.friendlyChildName + " to " + selectedItems.get(0).getName();
        } else {
            this.setEnabled(false);
            description = "Add " + this.friendlyChildName + " to selected " + this.friendlyParentName + " (" + ((KeyStroke)this.getValue("AcceleratorKey")).getKeyChar() + ")";
        }
        this.putValue("ShortDescription", description);
    }

    private class PlayPenWatcher
    implements SelectionListener {
        private PlayPenWatcher() {
        }

        @Override
        public void itemDeselected(SelectionEvent e) {
            CreateOLAPChildAction.this.updateActionState();
        }

        @Override
        public void itemSelected(SelectionEvent e) {
            CreateOLAPChildAction.this.updateActionState();
        }
    }
}

