/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import jde.util.ClassPathEntry;

class ClassPathDir
extends ClassPathEntry {
    private File directory;

    ClassPathDir(File directory) {
        this.directory = directory;
    }

    void load() {
        this.addRecursively(this.directory, this.directory);
        this.setLoaded(true);
    }

    void addRecursively(File directory, File rootDir) {
        String[] files = directory.list();
        if (files == null) {
            System.err.println("Cannot read contents of " + directory + ".");
            return;
        }
        String rootPath = rootDir.getPath();
        String currentPath = directory.getPath();
        String packageName = currentPath.substring(rootPath.length());
        StringBuffer buf = new StringBuffer();
        if (packageName.length() > 0) {
            packageName = packageName.replace('\\', '.');
            packageName = packageName.replace('/', '.');
            packageName = packageName.substring(1);
        }
        int i = 0;
        while (i < files.length) {
            String current = files[i];
            if (current.toLowerCase().endsWith(".class")) {
                current = current.substring(0, current.length() - 6);
                current = current.replace('$', '.');
                if (currentPath.indexOf(rootPath) != 0) {
                    System.err.println("currentPath doesn't start with rootPath!\nrootPath: " + rootPath + "\n" + "currentPath: " + currentPath + "\n");
                } else if (packageName.length() > 0) {
                    buf.append(packageName);
                    buf.append('.');
                    buf.append(current);
                    this.addClass(buf.toString());
                    buf.setLength(0);
                } else {
                    this.addClass(current);
                }
            } else {
                File currentFile = new File(directory, current);
                if (currentFile.isDirectory()) {
                    this.addRecursively(currentFile, rootDir);
                }
            }
            ++i;
        }
    }

    public String toString() {
        return this.directory.toString();
    }
}

