"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statsRoute = statsRoute;

var _common = require("../../common");

var _stats_helper = require("../common/stats/stats_helper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function statsRoute(router, logger) {
  router.get({
    path: `${_common.APP_API}${_common.APP_PATH.STATS}`,
    validate: {}
  }, async (context, request, response) => {
    try {
      const savedObjectsClient = context.core.savedObjects.client;
      const mapsSavedObjects = await (0, _stats_helper.getMapSavedObjects)(savedObjectsClient, _common.PER_PAGE_REQUEST_NUMBER);
      const stats = (0, _stats_helper.getStats)(mapsSavedObjects);
      return response.ok({
        body: stats
      });
    } catch (error) {
      logger.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXRzX3JvdXRlci50cyJdLCJuYW1lcyI6WyJzdGF0c1JvdXRlIiwicm91dGVyIiwibG9nZ2VyIiwiZ2V0IiwicGF0aCIsIkFQUF9BUEkiLCJBUFBfUEFUSCIsIlNUQVRTIiwidmFsaWRhdGUiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwic2F2ZWRPYmplY3RzQ2xpZW50IiwiY29yZSIsInNhdmVkT2JqZWN0cyIsImNsaWVudCIsIm1hcHNTYXZlZE9iamVjdHMiLCJQRVJfUEFHRV9SRVFVRVNUX05VTUJFUiIsInN0YXRzIiwib2siLCJib2R5IiwiZXJyb3IiLCJjdXN0b20iLCJzdGF0dXNDb2RlIiwibWVzc2FnZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQVlBOztBQUNBOztBQWJBO0FBQ0E7QUFDQTtBQUNBO0FBYU8sU0FBU0EsVUFBVCxDQUFvQkMsTUFBcEIsRUFBcUNDLE1BQXJDLEVBQXFEO0FBQzFERCxFQUFBQSxNQUFNLENBQUNFLEdBQVAsQ0FDRTtBQUNFQyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsZUFBUSxHQUFFQyxpQkFBU0MsS0FBTSxFQURwQztBQUVFQyxJQUFBQSxRQUFRLEVBQUU7QUFGWixHQURGLEVBS0UsT0FDRUMsT0FERixFQUVFQyxPQUZGLEVBR0VDLFFBSEYsS0FJa0U7QUFDaEUsUUFBSTtBQUNGLFlBQU1DLGtCQUFrQixHQUFHSCxPQUFPLENBQUNJLElBQVIsQ0FBYUMsWUFBYixDQUEwQkMsTUFBckQ7QUFDQSxZQUFNQyxnQkFBb0UsR0FDeEUsTUFBTSxzQ0FBbUJKLGtCQUFuQixFQUF1Q0ssK0JBQXZDLENBRFI7QUFFQSxZQUFNQyxLQUFLLEdBQUcsNEJBQVNGLGdCQUFULENBQWQ7QUFDQSxhQUFPTCxRQUFRLENBQUNRLEVBQVQsQ0FBWTtBQUNqQkMsUUFBQUEsSUFBSSxFQUFFRjtBQURXLE9BQVosQ0FBUDtBQUdELEtBUkQsQ0FRRSxPQUFPRyxLQUFQLEVBQWM7QUFDZG5CLE1BQUFBLE1BQU0sQ0FBQ21CLEtBQVAsQ0FBYUEsS0FBYjtBQUNBLGFBQU9WLFFBQVEsQ0FBQ1csTUFBVCxDQUFnQjtBQUNyQkMsUUFBQUEsVUFBVSxFQUFFRixLQUFLLENBQUNFLFVBQU4sSUFBb0IsR0FEWDtBQUVyQkgsUUFBQUEsSUFBSSxFQUFFQyxLQUFLLENBQUNHO0FBRlMsT0FBaEIsQ0FBUDtBQUlEO0FBQ0YsR0F6Qkg7QUEyQkQiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IFJlc3BvbnNlRXJyb3IgfSBmcm9tICdAb3BlbnNlYXJjaC1wcm9qZWN0L29wZW5zZWFyY2gvbGliL2Vycm9ycyc7XG5pbXBvcnQgeyBMb2dnZXIgfSBmcm9tICdAb3NkL2xvZ2dpbmcnO1xuaW1wb3J0IHtcbiAgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2UsXG4gIElSb3V0ZXIsXG4gIFNhdmVkT2JqZWN0c0ZpbmRSZXNwb25zZSxcbn0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7IEFQUF9BUEksIEFQUF9QQVRILCBQRVJfUEFHRV9SRVFVRVNUX05VTUJFUiB9IGZyb20gJy4uLy4uL2NvbW1vbic7XG5pbXBvcnQgeyBnZXRNYXBTYXZlZE9iamVjdHMsIGdldFN0YXRzIH0gZnJvbSAnLi4vY29tbW9uL3N0YXRzL3N0YXRzX2hlbHBlcic7XG5pbXBvcnQgeyBNYXBTYXZlZE9iamVjdEF0dHJpYnV0ZXMgfSBmcm9tICcuLi8uLi9jb21tb24vbWFwX3NhdmVkX29iamVjdF9hdHRyaWJ1dGVzJztcblxuZXhwb3J0IGZ1bmN0aW9uIHN0YXRzUm91dGUocm91dGVyOiBJUm91dGVyLCBsb2dnZXI6IExvZ2dlcikge1xuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke0FQUF9BUEl9JHtBUFBfUEFUSC5TVEFUU31gLFxuICAgICAgdmFsaWRhdGU6IHt9LFxuICAgIH0sXG4gICAgYXN5bmMgKFxuICAgICAgY29udGV4dCxcbiAgICAgIHJlcXVlc3QsXG4gICAgICByZXNwb25zZVxuICAgICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IHNhdmVkT2JqZWN0c0NsaWVudCA9IGNvbnRleHQuY29yZS5zYXZlZE9iamVjdHMuY2xpZW50O1xuICAgICAgICBjb25zdCBtYXBzU2F2ZWRPYmplY3RzOiBTYXZlZE9iamVjdHNGaW5kUmVzcG9uc2U8TWFwU2F2ZWRPYmplY3RBdHRyaWJ1dGVzPiA9XG4gICAgICAgICAgYXdhaXQgZ2V0TWFwU2F2ZWRPYmplY3RzKHNhdmVkT2JqZWN0c0NsaWVudCwgUEVSX1BBR0VfUkVRVUVTVF9OVU1CRVIpO1xuICAgICAgICBjb25zdCBzdGF0cyA9IGdldFN0YXRzKG1hcHNTYXZlZE9iamVjdHMpO1xuICAgICAgICByZXR1cm4gcmVzcG9uc2Uub2soe1xuICAgICAgICAgIGJvZHk6IHN0YXRzLFxuICAgICAgICB9KTtcbiAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgIGxvZ2dlci5lcnJvcihlcnJvcik7XG4gICAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICAgIHN0YXR1c0NvZGU6IGVycm9yLnN0YXR1c0NvZGUgfHwgNTAwLFxuICAgICAgICAgIGJvZHk6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cbiAgKTtcbn1cbiJdfQ==