// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/* Preconditions, postconditions, and loop invariants are very
 * useful for safe programing.  They also document the specifications.
 * This function is to help simplify the semantic burden of parsing
 * these constructions.
 *
 * Instead of constructions like
 * if (!goodCondition) throw new Error('condition not true')
 *
 * needs(goodCondition, 'condition not true')
 */
export function needs(condition, errorMessage, Err = Error) {
    if (!condition) {
        throw new Err(errorMessage);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVlZHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbmVlZHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0Qzs7Ozs7Ozs7O0dBU0c7QUFFSCxNQUFNLFVBQVUsS0FBSyxDQUNuQixTQUFjLEVBQ2QsWUFBb0IsRUFDcEIsTUFBd0IsS0FBSztJQUU3QixJQUFJLENBQUMsU0FBUyxFQUFFO1FBQ2QsTUFBTSxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQTtLQUM1QjtBQUNILENBQUMifQ==