"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCorrelationMethods = addCorrelationMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addCorrelationMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_CORRELATION_RULES] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/<%=ruleId%>`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/<%=ruleId%>`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_CORRELATED_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.FINDINGS_BASE}/correlate?finding=<%=finding%>&detector_type=<%=detector_type%>&nearby_findings=<%=nearby_findings%>`,
      req: {
        finding: {
          type: 'string',
          required: true
        },
        detector_type: {
          type: 'string',
          required: true
        },
        nearby_findings: {
          type: 'number',
          required: false
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_ALL_CORRELATIONS] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATIONS}?start_timestamp=<%=start_timestamp%>&end_timestamp=<%=end_timestamp%>`,
      req: {
        start_timestamp: {
          type: 'string',
          required: true
        },
        end_timestamp: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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