"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTypeService = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class LogTypeService {
  constructor(osDriver) {
    this.osDriver = osDriver;

    _defineProperty(this, "createLogType", async (_context, request, response) => {
      try {
        const logType = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const createLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.CREATE_LOGTYPE, {
          body: logType
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - createLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "searchLogTypes", async (_context, request, response) => {
      try {
        const query = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const searchLogTypesResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.SEARCH_LOGTYPES, {
          body: {
            size: 10000,
            query: query !== null && query !== void 0 ? query : {
              match_all: {}
            }
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchLogTypesResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - searchLogTypes:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "updateLogType", async (_context, request, response) => {
      try {
        const logType = request.body;
        const {
          logTypeId
        } = request.params;
        const params = {
          body: logType,
          logTypeId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const updateLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.UPDATE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - updateLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "deleteLogType", async (_context, request, response) => {
      try {
        const {
          logTypeId
        } = request.params;
        const params = {
          logTypeId
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const deleteLogTypeResponse = await callWithRequest(_constants.CLIENT_LOGTYPE_METHODS.DELETE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }

}

exports.LogTypeService = LogTypeService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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