"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Heatmap = void 0;
var __1 = require("../..");
var predicate_1 = require("../../../common/predicate");
var constants_1 = require("../../../scales/constants");
var constants_2 = require("../../../specs/constants");
var spec_factory_1 = require("../../../state/spec_factory");
var config_1 = require("../layout/config/config");
var scale_defaults_1 = require("./scale_defaults");
var defaultProps = {
    chartType: __1.ChartType.Heatmap,
    specType: constants_2.SpecType.Series,
    data: [],
    colors: ['red', 'yellow', 'green'],
    colorScale: constants_1.ScaleType.Linear,
    xAccessor: function (_a) {
        var x = _a.x;
        return x;
    },
    yAccessor: function (_a) {
        var y = _a.y;
        return y;
    },
    xScaleType: scale_defaults_1.X_SCALE_DEFAULT.type,
    valueAccessor: function (_a) {
        var value = _a.value;
        return value;
    },
    valueFormatter: function (value) { return "" + value; },
    xSortPredicate: predicate_1.Predicate.AlphaAsc,
    ySortPredicate: predicate_1.Predicate.AlphaAsc,
    config: config_1.config,
};
exports.Heatmap = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(defaultProps));
//# sourceMappingURL=heatmap.js.map