"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityAnalyticsPlugin = securityAnalyticsPlugin;

var _constants = require("../utils/constants");

var _addAlertsMethods = require("./addAlertsMethods");

var _addDetectorMethods = require("./addDetectorMethods");

var _addFieldMappingMethods = require("./addFieldMappingMethods");

var _addFindingsMethods = require("./addFindingsMethods");

var _addRuleMethods = require("./addRuleMethods");

var _addNotificationsMethods = require("./addNotificationsMethods");

var _addCorrelationMethods = require("./addCorrelationMethods");

var _addLogTypeMethods = require("./addLogTypeMethods");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function securityAnalyticsPlugin(Client, config, components) {
  const createAction = components.clientAction.factory;
  Client.prototype[_constants.PLUGIN_PROPERTY_NAME] = components.clientAction.namespaceFactory();
  const securityAnalytics = Client.prototype[_constants.PLUGIN_PROPERTY_NAME].prototype;
  (0, _addDetectorMethods.addDetectorMethods)(securityAnalytics, createAction);
  (0, _addCorrelationMethods.addCorrelationMethods)(securityAnalytics, createAction);
  (0, _addFieldMappingMethods.addFieldMappingMethods)(securityAnalytics, createAction);
  (0, _addFindingsMethods.addFindingsMethods)(securityAnalytics, createAction);
  (0, _addAlertsMethods.addAlertsMethods)(securityAnalytics, createAction);
  (0, _addRuleMethods.addRulesMethods)(securityAnalytics, createAction);
  (0, _addNotificationsMethods.addNotificationsMethods)(securityAnalytics, createAction);
  (0, _addLogTypeMethods.addLogTypeMethods)(securityAnalytics, createAction);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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