"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;

var _operators = require("rxjs/operators");

var _routes = require("./routes");

var _opensearch_security_configuration_plugin = _interopRequireDefault(require("./backend/opensearch_security_configuration_plugin"));

var _opensearch_security_plugin = _interopRequireDefault(require("./backend/opensearch_security_plugin"));

var _security_cookie = require("./session/security_cookie");

var _opensearch_security_client = require("./backend/opensearch_security_client");

var _tenant_index = require("./multitenancy/tenant_index");

var _auth_handler_factory = require("./auth/auth_handler_factory");

var _routes2 = require("./multitenancy/routes");

var _auth_type_routes = require("./routes/auth_type_routes");

var _core = require("../../../src/core/server/saved_objects/migrations/core");

var _saved_objects_wrapper = require("./saved_objects/saved_objects_wrapper");

var _tenant_resolver = require("./multitenancy/tenant_resolver");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SecurityPlugin {
  // FIXME: keep an reference of admin client so that it can be used in start(), better to figureout a
  //        decent way to get adminClient in start. (maybe using getStartServices() from setup?)
  // @ts-ignore: property not initialzied in constructor
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "securityClient", void 0);

    _defineProperty(this, "savedObjectClientWrapper", void 0);

    this.logger = initializerContext.logger.get();
    this.savedObjectClientWrapper = new _saved_objects_wrapper.SecuritySavedObjectsClientWrapper();
  }

  async setup(core) {
    var _config$multitenancy, _config$multitenancy2;

    this.logger.debug('opendistro_security: Setup');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const esClient = core.opensearch.legacy.createClient('opendistro_security', {
      plugins: [_opensearch_security_configuration_plugin.default, _opensearch_security_plugin.default]
    });
    this.securityClient = new _opensearch_security_client.SecurityClient(esClient);
    const securitySessionStorageFactory = await core.http.createCookieSessionStorageFactory((0, _security_cookie.getSecurityCookieOptions)(config)); // put logger into route handler context, so that we don't need to pass througth parameters

    core.http.registerRouteHandlerContext('security_plugin', (context, request) => {
      return {
        logger: this.logger,
        esClient
      };
    }); // setup auth

    const auth = await (0, _auth_handler_factory.getAuthenticationHandler)(config.auth.type, router, config, core, esClient, securitySessionStorageFactory, this.logger);
    core.http.registerAuth(auth.authHandler);
    /* Here we check if multitenancy is enabled to ensure if it is, we insert the tenant info (security_tenant) into the resolved, short URL so the page can correctly load with the right tenant information [Fix for issue 1203](https://github.com/opensearch-project/security-dashboards-plugin/issues/1203 */

    if ((_config$multitenancy = config.multitenancy) !== null && _config$multitenancy !== void 0 && _config$multitenancy.enabled) {
      core.http.registerOnPreResponse((request, preResponse, toolkit) => {
        (0, _tenant_resolver.addTenantParameterToResolvedShortLink)(request);
        return toolkit.next();
      });
    } // Register server side APIs


    (0, _routes.defineRoutes)(router);
    (0, _auth_type_routes.defineAuthTypeRoutes)(router, config); // set up multi-tenent routes

    if ((_config$multitenancy2 = config.multitenancy) !== null && _config$multitenancy2 !== void 0 && _config$multitenancy2.enabled) {
      (0, _routes2.setupMultitenantRoutes)(router, securitySessionStorageFactory, this.securityClient);
    }

    if (config.multitenancy.enabled && config.multitenancy.enable_aggregation_view) {
      core.savedObjects.addClientWrapper(2, 'security-saved-object-client-wrapper', this.savedObjectClientWrapper.wrapperFactory);
    }

    return {
      config$,
      securityConfigClient: esClient
    };
  } // TODO: add more logs


  async start(core) {
    var _config$multitenancy3;

    this.logger.debug('opendistro_security: Started');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    this.savedObjectClientWrapper.httpStart = core.http;
    this.savedObjectClientWrapper.config = config;

    if ((_config$multitenancy3 = config.multitenancy) !== null && _config$multitenancy3 !== void 0 && _config$multitenancy3.enabled) {
      const globalConfig$ = this.initializerContext.config.legacy.globalConfig$;
      const globalConfig = await globalConfig$.pipe((0, _operators.first)()).toPromise();
      const opensearchDashboardsIndex = globalConfig.opensearchDashboards.index;
      const typeRegistry = core.savedObjects.getTypeRegistry();
      const esClient = core.opensearch.client.asInternalUser;
      const migrationClient = (0, _core.createMigrationOpenSearchClient)(esClient, this.logger);
      (0, _tenant_index.setupIndexTemplate)(esClient, opensearchDashboardsIndex, typeRegistry, this.logger);
      const serializer = core.savedObjects.createSerializer();
      const opensearchDashboardsVersion = this.initializerContext.env.packageInfo.version;
      (0, _tenant_index.migrateTenantIndices)(opensearchDashboardsVersion, migrationClient, this.securityClient, typeRegistry, serializer, this.logger);
    }

    return {
      http: core.http,
      es: core.opensearch.legacy
    };
  }

  stop() {}

}

exports.SecurityPlugin = SecurityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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