/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.npm;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.extension.BuildFileProviderBase;
import org.jetbrains.security.extension.npm.NpmProjectDependenciesModel;
import org.jetbrains.security.model.ProjectDependenciesModel;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/security/extension/npm/NpmBuildFileProvider;", "Lorg/jetbrains/security/extension/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "getRoots", "", "Lorg/jetbrains/security/package/Package;", "", "pkgs", "importedPackages", "moduleScript", "module", "supports", "", "updatePackageDeclaration", "", "pkg", "version", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nNpmBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmBuildFileProvider.kt\norg/jetbrains/security/extension/npm/NpmBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n766#2:59\n857#2,2:60\n1271#2,2:62\n1285#2,4:64\n766#2:68\n857#2,2:69\n1855#2,2:71\n*S KotlinDebug\n*F\n+ 1 NpmBuildFileProvider.kt\norg/jetbrains/security/extension/npm/NpmBuildFileProvider\n*L\n34#1:55\n34#1:56,3\n35#1:59\n35#1:60,2\n43#1:62,2\n43#1:64,4\n48#1:68\n48#1:69,2\n49#1:71,2\n*E\n"})
public final class NpmBuildFileProvider
extends BuildFileProviderBase {
    public NpmBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Module getModule(@NotNull PsiFile file2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module2 = module = ProjectFileIndex.getInstance((Project)this.getProject()).getModuleForFile(file2.getVirtualFile());
        if (module2 == null) {
            throw new IllegalStateException("Non package.json file".toString());
        }
        return module2;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)module);
        if (virtualFile != null) {
            VirtualFile moduleRootDir = virtualFile;
            boolean bl = false;
            VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)moduleRootDir);
            if (virtualFile2 != null) {
                VirtualFile moduleScriptVirtualFile = virtualFile2;
                boolean bl2 = false;
                psiFile = this.getProject().isDisposed() || !moduleScriptVirtualFile.isValid() ? null : PsiManager.getInstance((Project)this.getProject()).findFile(moduleScriptVirtualFile);
            } else {
                psiFile = null;
            }
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        void $this$filterTo$iv$iv;
        Package it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        NpmProjectDependenciesModel dependencyModel = (NpmProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(NpmProjectDependenciesModel.class, (AreaInstance)this.getProject());
        List<Package> allImportedPackages = dependencyModel.getImportedPackages$intellij_packageChecker();
        Collection declaredDependencies2 = PackageJsonData.getOrCreate((VirtualFile)file2.getVirtualFile()).getAllDependencyEntries().values();
        Iterable $this$map$iv = declaredDependencies2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PackageJsonData.PackageJsonDependencyEntry packageJsonDependencyEntry = (PackageJsonData.PackageJsonDependencyEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List declaredDependenciesNames = (List)destination$iv$iv;
        Iterable $this$filter$iv = allImportedPackages;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Package)element$iv$iv;
            boolean bl = false;
            if (!declaredDependenciesNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return PackageJsonUtil.isPackageJsonFile((PsiFile)file2);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.moduleScript(module) != null;
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Iterable $this$associateWith$iv = this.importedPackages(file2);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Package package_ = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file2, @NotNull Package pkg, @NotNull String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JsonFile jsonFile = PackageJsonUtil.asPackageJsonFile((PsiFile)file2);
        if (jsonFile == null) {
            return;
        }
        JsonFile packageJsonFile = jsonFile;
        List list = PackageJsonUtil.getAllDependencies((JsonFile)packageJsonFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllDependencies(packageJsonFile)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonProperty it = (JsonProperty)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)pkg.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dependencyJsonProperties = (List)destination$iv$iv;
        Iterable $this$forEach$iv = dependencyJsonProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonProperty jsonProperty = (JsonProperty)element$iv;
            boolean bl = false;
            JsonElementGenerator generator = new JsonElementGenerator(jsonProperty.getProject());
            JsonProperty jsonProperty2 = jsonProperty;
            if (jsonProperty2 == null || (jsonProperty2 = jsonProperty2.getValue()) == null) continue;
            jsonProperty2.replace((PsiElement)generator.createStringLiteral(version));
        }
    }
}

