/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.fus.PackageCheckerUsageStat;
import org.jetbrains.security.model.LibraryDependency;
import org.jetbrains.security.model.impl.ProjectDependenciesModelImpl;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePath;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePaths;
import org.jetbrains.security.service.LibraryVulnerablePaths;
import org.jetbrains.security.service.PackageChecker;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.Vulnerable;
import org.jetbrains.security.service.VulnerableApiCallResult;
import org.jetbrains.security.service.VulnerableApiService;
import org.jetbrains.security.service.VulnerableQualifiedName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u0003:\u00015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020#H\u0016J\u001f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0014H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010*2\u0006\u0010.\u001a\u00020\u0011H\u0002J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0017J\u0013\u00102\u001a\u00020\u0014H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00100\u00160\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lorg/jetbrains/security/service/VulnerableApiService;", "Lcom/intellij/openapi/Disposable;", "Lkotlinx/coroutines/CoroutineScope;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "checker", "Lorg/jetbrains/security/service/PackageChecker;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "job", "libraryFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lorg/jetbrains/security/model/LibraryDependency;", "librarySignal", "Lkotlinx/coroutines/channels/Channel;", "", "libraryToVulnerabilityFlow", "", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "vulnerableCodeUsageInspectionCount", "", "afterLibraryAdded", "newLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "beforeLibraryRemoved", "library", "bindToFqn", "", "Lorg/jetbrains/security/service/VulnerableQualifiedName;", "libraryVulnerablePaths", "Lorg/jetbrains/security/service/LibraryVulnerablePaths;", "(Lorg/jetbrains/security/service/LibraryVulnerablePaths;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "findVulnerabilities", "lib", "isVulnerable", "Lorg/jetbrains/security/service/VulnerableApiCallResult;", "fqn", "refreshLibraries", "refreshLibraries$intellij_packageChecker", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableApiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableApiService.kt\norg/jetbrains/security/service/VulnerableApiService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,233:1\n1360#2:234\n1446#2,5:235\n361#3,7:240\n215#4,2:247\n*S KotlinDebug\n*F\n+ 1 VulnerableApiService.kt\norg/jetbrains/security/service/VulnerableApiService\n*L\n102#1:234\n102#1:235,5\n107#1:240,7\n117#1:247,2\n*E\n"})
public final class VulnerableApiService
implements Disposable,
CoroutineScope,
LibraryTable.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final Logger logger;
    private final ObjectMapper objectMapper;
    @NotNull
    private final CoroutineContext job;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Channel<Unit> librarySignal;
    private int vulnerableCodeUsageInspectionCount;
    @NotNull
    private final StateFlow<List<LibraryDependency>> libraryFlow;
    @NotNull
    private final PackageChecker checker;
    @NotNull
    private final StateFlow<Map<String, List<Vulnerability>>> libraryToVulnerabilityFlow;

    public VulnerableApiService(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(this::class.java)");
        this.logger = logger;
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.coroutineContext = this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)new CoroutineName("PackageChecker.VulnerableApiService." + this.module.getName()));
        this.librarySignal = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        this.libraryFlow = FlowKt.stateIn((Flow)FlowKt.mapLatest((Flow)FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.librarySignal)), (Function2)((Function2)new Function2<Unit, Continuation<? super List<? extends LibraryDependency>>, Object>(this, null){
            int label;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = com.intellij.openapi.progress.CoroutinesKt.blockingContext((Function0)((Function0)new Function0<List<? extends LibraryDependency>>(this.this$0){
                            final /* synthetic */ VulnerableApiService this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final List<LibraryDependency> invoke() {
                                Project project = VulnerableApiService.access$getModule$p(this.this$0).getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                                ComponentManager $this$service$iv = (ComponentManager)project;
                                boolean $i$f$service = false;
                                Class<ProjectDependenciesModelImpl> serviceClass$iv = ProjectDependenciesModelImpl.class;
                                Object object = $this$service$iv.getService(serviceClass$iv);
                                if (object == null) {
                                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                                }
                                return ((ProjectDependenciesModelImpl)object).libraryDependencies(VulnerableApiService.access$getModule$p(this.this$0));
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super List<? extends LibraryDependency>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this, (SharingStarted)SharingStarted.Companion.getLazily(), (Object)CollectionsKt.emptyList());
        LibraryTablesRegistrar.getInstance().getLibraryTable(this.module.getProject()).addListener((LibraryTable.Listener)this, (Disposable)this);
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)this.job, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.refreshLibraries$intellij_packageChecker((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        this.checker = PackageChecker.Companion.getInstance(project);
        this.libraryToVulnerabilityFlow = FlowKt.stateIn((Flow)FlowKt.catch((Flow)FlowKt.retry((Flow)FlowKt.flowCombine((Flow)((Flow)this.libraryFlow), (Flow)((Flow)this.checker.getVulnerabilitiesFlow()), (Function3)((Function3)new Function3<List<? extends LibraryDependency>, Map<Package, ? extends PackageStatus>, Continuation<? super Map<String, ? extends List<? extends Vulnerability>>>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        a = (List)this.L$0;
                        var3_4 = a;
                        var4_5 = this.this$0;
                        $i$f$flatMap = false;
                        var6_9 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var9_14 = $this$flatMapTo$iv$iv.iterator();
lbl13:
                        // 2 sources

                        while (var9_14.hasNext()) {
                            element$iv$iv = var9_14.next();
                            library = (LibraryDependency)element$iv$iv;
                            $i$a$-flatMap-VulnerableApiService$libraryToVulnerabilityFlow$1$1 = false;
                            this.L$0 = var4_5;
                            this.L$1 = destination$iv$iv;
                            this.L$2 = var9_14;
                            this.label = 1;
                            v0 = com.intellij.openapi.progress.CoroutinesKt.blockingContext((Function0)((Function0)new Function0<LibraryVulnerablePaths>(var4_5, library){
                                final /* synthetic */ VulnerableApiService this$0;
                                final /* synthetic */ LibraryDependency $library;
                                {
                                    this.this$0 = $receiver;
                                    this.$library = $library;
                                    super(0);
                                }

                                @Nullable
                                public final LibraryVulnerablePaths invoke() {
                                    return VulnerableApiService.access$findVulnerabilities(this.this$0, this.$library);
                                }
                            }), (Continuation)this);
                            if (v0 == var21_2) {
                                return var21_2;
                            }
                            ** GOTO lbl35
                        }
                        break;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerableApiService$libraryToVulnerabilityFlow$1$1 = false;
                        var9_14 = (Iterator<T>)this.L$2;
                        destination$iv$iv = (Collection)this.L$1;
                        var4_5 = (VulnerableApiService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        if ((LibraryVulnerablePaths)v0 != null) ** GOTO lbl38
                        v1 = SetsKt.emptySet();
                        ** GOTO lbl56
lbl38:
                        // 1 sources

                        this.L$0 = var4_5;
                        this.L$1 = destination$iv$iv;
                        this.L$2 = var9_14;
                        this.label = 2;
                        v2 = VulnerableApiService.access$bindToFqn(var4_5, paths, (Continuation)this);
                        if (v2 == var21_2) {
                            return var21_2;
                        }
                        ** GOTO lbl55
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerableApiService$libraryToVulnerabilityFlow$1$1 = false;
                        var9_14 = (Iterator)this.L$2;
                        destination$iv$iv = (Collection)this.L$1;
                        var4_5 = (VulnerableApiService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl55:
                        // 2 sources

                        v1 = (Set)v2;
lbl56:
                        // 2 sources

                        list$iv$iv = v1;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        ** GOTO lbl13
                    }
                }
                $this$groupBy$iv = (List)destination$iv$iv;
                $i$f$groupBy = false;
                $i$f$flatMap = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$groupByTo = false;
                $i$f$flatMapTo = $this$groupByTo$iv$iv.iterator();
                while ($i$f$flatMapTo.hasNext()) {
                    element$iv$iv = $i$f$flatMapTo.next();
                    it = (VulnerableQualifiedName)element$iv$iv;
                    $i$a$-groupBy-VulnerableApiService$libraryToVulnerabilityFlow$1$2 = false;
                    key$iv$iv = it.getFqn();
                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv /* !! */  = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv /* !! */  == null) {
                        $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$2$iv$iv = false;
                        answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        v3 /* !! */  = answer$iv$iv$iv;
                    } else {
                        v3 /* !! */  = value$iv$iv$iv /* !! */ ;
                    }
                    list$iv$iv = (List)v3 /* !! */ ;
                    $i$a$-groupBy-VulnerableApiService$libraryToVulnerabilityFlow$1$2 = (VulnerableQualifiedName)element$iv$iv;
                    var18_32 = list$iv$iv;
                    $i$a$-groupBy-VulnerableApiService$libraryToVulnerabilityFlow$1$3 = false;
                    var18_32.add(it.getVulnerabilities());
                }
                $this$mapValues$iv = destination$iv$iv;
                $i$f$mapValues = false;
                $this$groupByTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                $i$f$mapValuesTo = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    key$iv$iv = (Map.Entry)element$iv$iv$iv;
                    var13_26 = destination$iv$iv;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    value$iv$iv$iv /* !! */  = (Map.Entry)element$iv$iv$iv;
                    var19_33 = it$iv$iv.getKey();
                    var18_32 = var13_26;
                    $i$a$-mapValues-VulnerableApiService$libraryToVulnerabilityFlow$1$4 = false;
                    var20_34 = CollectionsKt.flatten((Iterable)((Iterable)it.getValue()));
                    var18_32.put(var19_33, var20_34);
                }
                return destination$iv$iv;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull List<? extends LibraryDependency> p1, @NotNull Map<Package, ? extends PackageStatus> p2, @Nullable Continuation<? super Map<String, ? extends List<Vulnerability>>> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (long)3L, (Function2)((Function2)new Function2<Throwable, Continuation<? super Boolean>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        it = (Throwable)this.L$0;
                        this.L$0 = it;
                        this.label = 1;
                        v0 = DelayKt.delay((long)10000L, (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        it = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        VulnerableApiService.access$getLogger$p(this.this$0).info("Error on parsing libraries, retry");
                        return Boxing.boxBoolean((boolean)(it instanceof Exception));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Throwable p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super Map<String, ? extends List<? extends Vulnerability>>>, Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        VulnerableApiService.access$getLogger$p(this.this$0).warn("retry failed", it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Map<String, ? extends List<Vulnerability>>> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)MapsKt.emptyMap());
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void afterLibraryAdded(@NotNull Library newLibrary) {
        Intrinsics.checkNotNullParameter((Object)newLibrary, (String)"newLibrary");
        super.afterLibraryAdded(newLibrary);
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.refreshLibraries$intellij_packageChecker((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void beforeLibraryRemoved(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        super.beforeLibraryRemoved(library);
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VulnerableApiService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.refreshLibraries$intellij_packageChecker((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final LibraryVulnerablePaths findVulnerabilities(LibraryDependency lib) {
        Package package_ = lib.createPackage();
        if (package_ == null) {
            return null;
        }
        Package pkg = package_;
        PackageStatus packageStatus = this.checker.packageStatus(pkg);
        Vulnerable vulnerable = packageStatus instanceof Vulnerable ? (Vulnerable)packageStatus : null;
        if (vulnerable == null) {
            return null;
        }
        Vulnerable vulnerableStatus = vulnerable;
        VulnerablePackage vulnerablePkg = vulnerableStatus.getVulnerablePackage();
        Map pathToVulnerability = new LinkedHashMap();
        for (Vulnerability vulnerability : vulnerablePkg.getVulnerabilities()) {
            void $this$flatMapTo$iv$iv;
            List list;
            Iterable it;
            ProgressManager.checkCanceled();
            if (vulnerability.getVulnerablePathsString() != null) {
                boolean bl = false;
                v2 = (List)this.objectMapper.readValue((String)((Object)it), (TypeReference)new TypeReference<List<? extends VulnerablePaths>>(){});
            } else {
                v2 = list = null;
            }
            if (list == null) continue;
            List vulnerablePathsSerialized2 = list;
            Iterable $this$flatMap$iv = vulnerablePathsSerialized2;
            boolean $i$f$flatMap = false;
            it = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                VulnerablePaths it2 = (VulnerablePaths)element$iv$iv;
                boolean bl = false;
                List list2 = it2.getVPath();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List vulnerablePaths = (List)destination$iv$iv;
            if (vulnerablePaths.isEmpty()) continue;
            for (VulnerablePath path : vulnerablePaths) {
                Object object;
                Map $this$getOrPut$iv = pathToVulnerability;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(path);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(path, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(vulnerability);
            }
        }
        return new LibraryVulnerablePaths(lib, pathToVulnerability);
    }

    /*
     * Unable to fully structure code
     */
    private final Object bindToFqn(LibraryVulnerablePaths var1_1, Continuation<? super Set<VulnerableQualifiedName>> var2_2) {
        if (!(var2_2 instanceof bindToFqn.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerableApiService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerableApiService.access$bindToFqn(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module.project");
                project = v0;
                $this$bindToFqn_u24lambda_u244 = var5_8 = (result = (Set)new LinkedHashSet<E>());
                $i$a$-apply-VulnerableApiService$bindToFqn$2 = false;
                $this$forEach$iv = libraryVulnerablePaths.getVulnerabilities();
                $i$f$forEach = false;
                var10_13 = $this$forEach$iv.entrySet().iterator();
lbl20:
                // 3 sources

                while (var10_13.hasNext()) {
                    var12_15 = element$iv = var10_13.next();
                    $i$a$-forEach-VulnerableApiService$bindToFqn$2$1 = false;
                    path = var12_15.getKey();
                    vulnerabilityList = var12_15.getValue();
                    JobKt.ensureActive((CoroutineContext)this.getCoroutineContext());
                    $continuation.L$0 = this;
                    $continuation.L$1 = libraryVulnerablePaths;
                    $continuation.L$2 = project;
                    $continuation.L$3 = var5_8;
                    $continuation.L$4 = $this$bindToFqn_u24lambda_u244;
                    $continuation.L$5 = var10_13;
                    $continuation.label = 1;
                    v1 = CoroutinesKt.smartReadAction((Project)project, (Function0)((Function0)new Function0<Unit>(libraryVulnerablePaths, project, path, (Set<VulnerableQualifiedName>)$this$bindToFqn_u24lambda_u244, vulnerabilityList, this){
                        final /* synthetic */ LibraryVulnerablePaths $libraryVulnerablePaths;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ VulnerablePath $path;
                        final /* synthetic */ Set<VulnerableQualifiedName> $this_apply;
                        final /* synthetic */ List<Vulnerability> $vulnerabilityList;
                        final /* synthetic */ VulnerableApiService this$0;
                        {
                            this.$libraryVulnerablePaths = $libraryVulnerablePaths;
                            this.$project = $project;
                            this.$path = $path;
                            this.$this_apply = $receiver;
                            this.$vulnerabilityList = $vulnerabilityList;
                            this.this$0 = $receiver2;
                            super(0);
                        }

                        public final void invoke() {
                            try {
                                String fqn = this.$libraryVulnerablePaths.getLib().getVulnerableElementQualifiedName(this.$project, this.$path);
                                if (fqn != null) {
                                    this.$this_apply.add(new VulnerableQualifiedName(fqn, this.$vulnerabilityList));
                                }
                            }
                            catch (IncorrectOperationException e) {
                                VulnerableApiService.access$getLogger$p(this.this$0).warn("Processing " + this.$path, (Throwable)e);
                                return;
                            }
                        }
                    }), (Continuation)$continuation);
                    if (v1 != var18_5) continue;
                    return var18_5;
                }
                break;
            }
            case 1: {
                $i$a$-apply-VulnerableApiService$bindToFqn$2 = false;
                $i$f$forEach = false;
                $i$a$-forEach-VulnerableApiService$bindToFqn$2$1 = false;
                var10_13 = (Iterator<Map.Entry<VulnerablePath, List<Vulnerability>>>)$continuation.L$5;
                $this$bindToFqn_u24lambda_u244 = (Set)$continuation.L$4;
                var5_8 = (Set)$continuation.L$3;
                project = (Project)$continuation.L$2;
                libraryVulnerablePaths = (LibraryVulnerablePaths)$continuation.L$1;
                this = (VulnerableApiService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl20
            }
        }
        return var5_8;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
        PackageCheckerUsageStat.localPathInspectionResult.log(this.module.getProject(), (Object)this.vulnerableCodeUsageInspectionCount);
        CoroutineScopeKt.cancel$default((CoroutineScope)this, (String)("Disposing " + this.getClass()), null, (int)2, null);
    }

    @NotNull
    public final VulnerableApiCallResult isVulnerable(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        List list = (List)((Map)this.libraryToVulnerabilityFlow.getValue()).get(fqn);
        if (list == null || (list = CollectionsKt.distinct((Iterable)list)) == null) {
            return new VulnerableApiCallResult(false, CollectionsKt.emptyList());
        }
        List vulnerabilities = list;
        if (vulnerabilities.isEmpty()) {
            return new VulnerableApiCallResult(false, CollectionsKt.emptyList());
        }
        ++this.vulnerableCodeUsageInspectionCount;
        return new VulnerableApiCallResult(true, vulnerabilities);
    }

    @Nullable
    public final Object refreshLibraries$intellij_packageChecker(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.librarySignal.send((Object)Unit.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final VulnerableApiService getInstance(@NotNull Module module) {
        return Companion.getInstance(module);
    }

    public static final /* synthetic */ Object access$bindToFqn(VulnerableApiService $this, LibraryVulnerablePaths libraryVulnerablePaths, Continuation $completion) {
        return $this.bindToFqn(libraryVulnerablePaths, (Continuation<? super Set<VulnerableQualifiedName>>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(VulnerableApiService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Module access$getModule$p(VulnerableApiService $this) {
        return $this.module;
    }

    public static final /* synthetic */ LibraryVulnerablePaths access$findVulnerabilities(VulnerableApiService $this, LibraryDependency lib) {
        return $this.findVulnerabilities(lib);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/security/service/VulnerableApiService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/security/service/VulnerableApiService;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VulnerableApiService getInstance(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Object object = module.getService(VulnerableApiService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module.getService(Vulner\u2026leApiService::class.java)");
            return (VulnerableApiService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

