/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.CompilerRefDescriptor;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;

public final class JavaCompilerIndices {
    public static final int VERSION = 7;
    public static final IndexId<CompilerRef, Integer> BACK_USAGES = IndexId.create((String)"back.refs");
    public static final IndexId<CompilerRef, Collection<CompilerRef>> BACK_HIERARCHY = IndexId.create((String)"back.hierarchy");
    public static final IndexId<CompilerRef, Void> BACK_CLASS_DEF = IndexId.create((String)"back.class.def");
    public static final IndexId<SignatureData, Collection<CompilerRef>> BACK_MEMBER_SIGN = IndexId.create((String)"back.member.sign");
    public static final IndexId<CompilerRef, Collection<CompilerRef>> BACK_CAST = IndexId.create((String)"back.cast");
    public static final IndexId<CompilerRef, Void> IMPLICIT_TO_STRING = IndexId.create((String)"implicit.to.string");

    public static List<IndexExtension<?, ?, CompiledFileData>> getIndices() {
        return Arrays.asList(JavaCompilerIndices.createBackwardClassDefinitionExtension(), JavaCompilerIndices.createBackwardUsagesExtension(), JavaCompilerIndices.createBackwardHierarchyExtension(), JavaCompilerIndices.createBackwardSignatureExtension(), JavaCompilerIndices.createBackwardCastExtension(), JavaCompilerIndices.createImplicitToStringExtension());
    }

    private static IndexExtension<CompilerRef, Void, CompiledFileData> createImplicitToStringExtension() {
        return new IndexExtension<CompilerRef, Void, CompiledFileData>(){

            @NotNull
            public IndexId<CompilerRef, Void> getName() {
                IndexId<CompilerRef, Void> indexId = IMPLICIT_TO_STRING;
                if (indexId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<CompilerRef, Void, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getImplicitToString;
                if (dataIndexer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                CompilerRefDescriptor compilerRefDescriptor = CompilerRefDescriptor.INSTANCE;
                if (compilerRefDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return compilerRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    1.$$$reportNull$$$0(3);
                }
                return voidDataExternalizer;
            }

            public int getVersion() {
                return 7;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData> createBackwardCastExtension() {
        return new IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData>(){

            @NotNull
            public IndexId<CompilerRef, Collection<CompilerRef>> getName() {
                IndexId<CompilerRef, Collection<CompilerRef>> indexId = BACK_CAST;
                if (indexId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<CompilerRef, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getCasts;
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                CompilerRefDescriptor compilerRefDescriptor = CompilerRefDescriptor.INSTANCE;
                if (compilerRefDescriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                return compilerRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                DataExternalizer<Collection<CompilerRef>> dataExternalizer = JavaCompilerIndices.createCompilerRefSeqExternalizer();
                if (dataExternalizer == null) {
                    2.$$$reportNull$$$0(3);
                }
                return dataExternalizer;
            }

            public int getVersion() {
                return 7;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<CompilerRef, Integer, CompiledFileData> createBackwardUsagesExtension() {
        return new IndexExtension<CompilerRef, Integer, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Integer> getName() {
                IndexId<CompilerRef, Integer> indexId = BACK_USAGES;
                if (indexId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<CompilerRef, Integer, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getReferences;
                if (dataIndexer == null) {
                    3.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                CompilerRefDescriptor compilerRefDescriptor = CompilerRefDescriptor.INSTANCE;
                if (compilerRefDescriptor == null) {
                    3.$$$reportNull$$$0(2);
                }
                return compilerRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Integer> getValueExternalizer() {
                return new UnsignedByteExternalizer();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData> createBackwardHierarchyExtension() {
        return new IndexExtension<CompilerRef, Collection<CompilerRef>, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Collection<CompilerRef>> getName() {
                IndexId<CompilerRef, Collection<CompilerRef>> indexId = BACK_HIERARCHY;
                if (indexId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<CompilerRef, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getBackwardHierarchy;
                if (dataIndexer == null) {
                    4.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                CompilerRefDescriptor compilerRefDescriptor = CompilerRefDescriptor.INSTANCE;
                if (compilerRefDescriptor == null) {
                    4.$$$reportNull$$$0(2);
                }
                return compilerRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                DataExternalizer<Collection<CompilerRef>> dataExternalizer = JavaCompilerIndices.createCompilerRefSeqExternalizer();
                if (dataExternalizer == null) {
                    4.$$$reportNull$$$0(3);
                }
                return dataExternalizer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<CompilerRef, Void, CompiledFileData> createBackwardClassDefinitionExtension() {
        return new IndexExtension<CompilerRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 7;
            }

            @NotNull
            public IndexId<CompilerRef, Void> getName() {
                IndexId<CompilerRef, Void> indexId = BACK_CLASS_DEF;
                if (indexId == null) {
                    5.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<CompilerRef, Void, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getDefinitions;
                if (dataIndexer == null) {
                    5.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<CompilerRef> getKeyDescriptor() {
                CompilerRefDescriptor compilerRefDescriptor = CompilerRefDescriptor.INSTANCE;
                if (compilerRefDescriptor == null) {
                    5.$$$reportNull$$$0(2);
                }
                return compilerRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    5.$$$reportNull$$$0(3);
                }
                return voidDataExternalizer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static IndexExtension<SignatureData, Collection<CompilerRef>, CompiledFileData> createBackwardSignatureExtension() {
        return new IndexExtension<SignatureData, Collection<CompilerRef>, CompiledFileData>(){

            @NotNull
            public IndexId<SignatureData, Collection<CompilerRef>> getName() {
                IndexId<SignatureData, Collection<CompilerRef>> indexId = BACK_MEMBER_SIGN;
                if (indexId == null) {
                    6.$$$reportNull$$$0(0);
                }
                return indexId;
            }

            @NotNull
            public DataIndexer<SignatureData, Collection<CompilerRef>, CompiledFileData> getIndexer() {
                DataIndexer dataIndexer = CompiledFileData::getSignatureData;
                if (dataIndexer == null) {
                    6.$$$reportNull$$$0(1);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<SignatureData> getKeyDescriptor() {
                KeyDescriptor<SignatureData> keyDescriptor = JavaCompilerIndices.createSignatureDataDescriptor();
                if (keyDescriptor == null) {
                    6.$$$reportNull$$$0(2);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<CompilerRef>> getValueExternalizer() {
                DataExternalizer<Collection<CompilerRef>> dataExternalizer = JavaCompilerIndices.createCompilerRefSeqExternalizer();
                if (dataExternalizer == null) {
                    6.$$$reportNull$$$0(3);
                }
                return dataExternalizer;
            }

            public int getVersion() {
                return 7;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static DataExternalizer<Collection<CompilerRef>> createCompilerRefSeqExternalizer() {
        return new DataExternalizer<Collection<CompilerRef>>(){

            public void save(@NotNull DataOutput out, Collection<CompilerRef> value) throws IOException {
                if (out == null) {
                    7.$$$reportNull$$$0(0);
                }
                DataInputOutputUtilRt.writeSeq((DataOutput)out, value, lightRef -> CompilerRefDescriptor.INSTANCE.save(out, (CompilerRef)lightRef));
            }

            public Collection<CompilerRef> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    7.$$$reportNull$$$0(1);
                }
                return DataInputOutputUtilRt.readSeq((DataInput)in, () -> CompilerRefDescriptor.INSTANCE.read(in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static KeyDescriptor<SignatureData> createSignatureDataDescriptor() {
        return new KeyDescriptor<SignatureData>(){

            public int getHashCode(SignatureData value) {
                return value.hashCode();
            }

            public boolean isEqual(SignatureData val1, SignatureData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, SignatureData value) throws IOException {
                if (out == null) {
                    8.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getRawReturnType());
                out.writeByte(value.getIteratorKind());
                out.writeBoolean(value.isStatic());
            }

            public SignatureData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    8.$$$reportNull$$$0(1);
                }
                return new SignatureData(DataInputOutputUtil.readINT((DataInput)in), in.readByte(), in.readBoolean());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static class UnsignedByteExternalizer
    implements DataExternalizer<Integer> {
        private UnsignedByteExternalizer() {
        }

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            int v;
            if (out == null) {
                UnsignedByteExternalizer.$$$reportNull$$$0(0);
            }
            if ((v = value.intValue()) > 255) {
                v = 255;
            }
            out.writeByte(v);
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                UnsignedByteExternalizer.$$$reportNull$$$0(1);
            }
            return in.readByte() & 0xFF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/backwardRefs/index/JavaCompilerIndices$UnsignedByteExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

