/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContext {
    private final CompileScope myScope;
    private final MessageHandler myDelegateMessageHandler;
    private final Set<ModuleBuildTarget> myNonIncrementalModules;
    private final Object2LongMap<BuildTarget<?>> myCompilationStartStamp;
    private final ProjectDescriptor myProjectDescriptor;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    private volatile float myDone;
    private final EventDispatcher<BuildListener> myListeners;

    CompileContextImpl(@NotNull CompileScope scope, @NotNull ProjectDescriptor pd, @NotNull MessageHandler delegateMessageHandler, @NotNull Map<String, String> builderParams, @NotNull CanceledStatus cancelStatus) {
        if (scope == null) {
            CompileContextImpl.$$$reportNull$$$0(0);
        }
        if (pd == null) {
            CompileContextImpl.$$$reportNull$$$0(1);
        }
        if (delegateMessageHandler == null) {
            CompileContextImpl.$$$reportNull$$$0(2);
        }
        if (builderParams == null) {
            CompileContextImpl.$$$reportNull$$$0(3);
        }
        if (cancelStatus == null) {
            CompileContextImpl.$$$reportNull$$$0(4);
        }
        this.myNonIncrementalModules = new HashSet<ModuleBuildTarget>();
        this.myCompilationStartStamp = new Object2LongOpenHashMap();
        this.myDone = -1.0f;
        this.myListeners = EventDispatcher.create(BuildListener.class);
        this.myProjectDescriptor = pd;
        this.myBuilderParams = Collections.unmodifiableMap(builderParams);
        this.myCancelStatus = cancelStatus;
        this.myScope = scope;
        this.myDelegateMessageHandler = delegateMessageHandler;
    }

    @TestOnly
    public static CompileContext createContextForTests(@NotNull CompileScope scope, @NotNull ProjectDescriptor descriptor) {
        if (scope == null) {
            CompileContextImpl.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            CompileContextImpl.$$$reportNull$$$0(6);
        }
        return new CompileContextImpl(scope, descriptor, DEAF, Collections.emptyMap(), CanceledStatus.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompilationStartStamp(BuildTarget<?> target) {
        Object2LongMap<BuildTarget<?>> object2LongMap = this.myCompilationStartStamp;
        synchronized (object2LongMap) {
            return this.myCompilationStartStamp.getLong(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompilationStartStamp(@NotNull Collection<? extends BuildTarget<?>> targets, long stamp) {
        if (targets == null) {
            CompileContextImpl.$$$reportNull$$$0(7);
        }
        Object2LongMap<BuildTarget<?>> object2LongMap = this.myCompilationStartStamp;
        synchronized (object2LongMap) {
            for (BuildTarget<?> target : targets) {
                this.myCompilationStartStamp.put(target, stamp);
            }
        }
    }

    public boolean isMake() {
        return JavaBuilderUtil.isCompileJavaIncrementally(this);
    }

    @Override
    public boolean isProjectRebuild() {
        return JavaBuilderUtil.isForcedRecompilationAllJavaModules(this);
    }

    @Override
    @NotNull
    public BuildLoggingManager getLoggingManager() {
        BuildLoggingManager buildLoggingManager = this.myProjectDescriptor.getLoggingManager();
        if (buildLoggingManager == null) {
            CompileContextImpl.$$$reportNull$$$0(8);
        }
        return buildLoggingManager;
    }

    @Override
    @Nullable
    public String getBuilderParameter(String paramName) {
        return this.myBuilderParams.get(paramName);
    }

    @Override
    public void addBuildListener(@NotNull BuildListener listener) {
        if (listener == null) {
            CompileContextImpl.$$$reportNull$$$0(9);
        }
        this.myListeners.addListener((EventListener)listener);
    }

    @Override
    public void removeBuildListener(@NotNull BuildListener listener) {
        if (listener == null) {
            CompileContextImpl.$$$reportNull$$$0(10);
        }
        this.myListeners.removeListener((EventListener)listener);
    }

    @Override
    public void markNonIncremental(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            CompileContextImpl.$$$reportNull$$$0(11);
        }
        if (!target.isTests()) {
            this.myNonIncrementalModules.add(new ModuleBuildTarget(target.getModule(), JavaModuleBuildTargetType.TEST));
        }
        this.myNonIncrementalModules.add(target);
    }

    @Override
    public boolean shouldDifferentiate(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            CompileContextImpl.$$$reportNull$$$0(12);
        }
        if (this.myNonIncrementalModules.isEmpty()) {
            return true;
        }
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (!this.myNonIncrementalModules.contains(target)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final CanceledStatus getCancelStatus() {
        CanceledStatus canceledStatus = this.myCancelStatus;
        if (canceledStatus == null) {
            CompileContextImpl.$$$reportNull$$$0(13);
        }
        return canceledStatus;
    }

    @Override
    public final void checkCanceled() throws ProjectBuildException {
        if (this.getCancelStatus().isCanceled()) {
            throw new StopBuildException(JpsBuildBundle.message("build.message.the.build.has.been.canceled", new Object[0]));
        }
    }

    @Override
    public void clearNonIncrementalMark(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            CompileContextImpl.$$$reportNull$$$0(14);
        }
        this.myNonIncrementalModules.remove(target);
    }

    @Override
    @NotNull
    public CompileScope getScope() {
        CompileScope compileScope = this.myScope;
        if (compileScope == null) {
            CompileContextImpl.$$$reportNull$$$0(15);
        }
        return compileScope;
    }

    @Override
    public void processMessage(BuildMessage msg) {
        if (msg.getKind() == BuildMessage.Kind.ERROR) {
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)this, (Object)Boolean.TRUE);
        }
        if (msg instanceof ProgressMessage) {
            ((ProgressMessage)msg).setDone(this.myDone);
        }
        this.myDelegateMessageHandler.processMessage(msg);
        if (msg instanceof FileGeneratedEvent) {
            ((BuildListener)this.myListeners.getMulticaster()).filesGenerated((FileGeneratedEvent)msg);
        } else if (msg instanceof FileDeletedEvent) {
            ((BuildListener)this.myListeners.getMulticaster()).filesDeleted((FileDeletedEvent)msg);
        }
    }

    @Override
    public void setDone(float done) {
        this.myDone = done;
    }

    @Override
    @NotNull
    public ProjectDescriptor getProjectDescriptor() {
        ProjectDescriptor projectDescriptor = this.myProjectDescriptor;
        if (projectDescriptor == null) {
            CompileContextImpl.$$$reportNull$$$0(16);
        }
        return projectDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pd";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateMessageHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderParams";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/CompileContextImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/CompileContextImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingManager";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelStatus";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContextForTests";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCompilationStartStamp";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBuildListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeBuildListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "markNonIncremental";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldDifferentiate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearNonIncrementalMark";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

