/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.SmartList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AffectedMembersCache;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;

public class GroovyConstructorNamedArgumentsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Override
    protected String buildErrorString(Object ... args) {
        assert (args.length == 1 && args[0] instanceof String);
        return (String)args[0];
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
            if (listOrMap == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super.visitListOrMap(listOrMap);
            GroovyConstructorReference reference = listOrMap.getConstructorReference();
            if (reference == null) {
                return;
            }
            this.processConstructor(listOrMap, reference.advancedResolve());
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression newExpression) {
            if (newExpression == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            super.visitNewExpression(newExpression);
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            GroovyResolveResult constructorResolveResult = newExpression.advancedResolve();
            GrNamedArgumentsOwner owner = MyVisitor.getNamedArgumentsOwner(newExpression);
            if (owner == null) {
                return;
            }
            this.processConstructor(owner, constructorResolveResult);
        }

        public void processConstructor(@NotNull GrNamedArgumentsOwner owner, @NotNull GroovyResolveResult constructorResolveResult) {
            PsiElement constructor;
            if (owner == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (constructorResolveResult == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((constructor = constructorResolveResult.getElement()) != null) {
                PsiAnnotation annotation;
                if (!PsiUtil.isConstructorHasRequiredParameters((PsiMethod)constructor)) {
                    this.checkDefaultMapConstructor(owner, constructor);
                    return;
                }
                PsiClass containingClass = ((PsiMethod)constructor).getContainingClass();
                if (containingClass != null && (annotation = containingClass.getAnnotation("groovy.transform.MapConstructor")) != null) {
                    this.checkGeneratedMapConstructor(owner, containingClass, annotation);
                }
            }
        }

        private void checkGeneratedMapConstructor(@NotNull GrNamedArgumentsOwner owner, @NotNull PsiClass containingClass, @NotNull PsiAnnotation annotation) {
            if (owner == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (containingClass == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (annotation == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            Lazy affectedMembers = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> GrGeneratedConstructorUtils.getAffectedMembersCache(annotation).getAffectedMembers().stream().map(AffectedMembersCache::getExternalName).filter(Objects::nonNull).collect(Collectors.toSet()));
            for (GrNamedArgument argument : owner.getNamedArguments()) {
                PsiElement resolved;
                GrArgumentLabel label = argument.getLabel();
                if (label == null) continue;
                GroovyPropertyWriteReference propertyReference = label.getConstructorPropertyReference();
                PsiElement psiElement = resolved = propertyReference == null ? null : propertyReference.resolve();
                if (resolved != null) {
                    String name = label.getName();
                    if (name == null || ((Set)affectedMembers.getValue()).contains(name)) continue;
                    LocalQuickFix[] fix = MyVisitor.generateMapConstructorFix(resolved, containingClass, annotation);
                    this.registerError((PsiElement)label, GroovyBundle.message("inspection.message.property.0.is.ignored.by.map.constructor", name), fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    continue;
                }
                this.registerAbsentIdentifierError(containingClass, label);
            }
        }

        private static LocalQuickFix @NotNull [] generateMapConstructorFix(@NotNull PsiElement resolvedElement, @NotNull PsiClass containingClass, @NotNull PsiAnnotation annotation) {
            if (resolvedElement == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (containingClass == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (annotation == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if (annotation instanceof LightElement) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyVisitor.$$$reportNull$$$0(10);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (!(containingClass instanceof GrTypeDefinition)) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyVisitor.$$$reportNull$$$0(11);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (!(resolvedElement instanceof PsiMember)) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyVisitor.$$$reportNull$$$0(12);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (((PsiMember)resolvedElement).getContainingClass() != containingClass && resolvedElement instanceof PsiMethod) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyVisitor.$$$reportNull$$$0(13);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (annotation.hasAttribute("includes") || annotation.hasAttribute("excludes")) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyVisitor.$$$reportNull$$$0(14);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createMapConstructorFix()};
            if (localQuickFixArray == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            return localQuickFixArray;
        }

        private void registerAbsentIdentifierError(@NotNull PsiClass clazz, @NotNull GrArgumentLabel label) {
            if (clazz == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            if (label == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            SmartList fixes = new SmartList();
            if (clazz instanceof GrTypeDefinition) {
                fixes.add(GroovyQuickFixFactory.getInstance().createCreateFieldFromConstructorLabelFix((GrTypeDefinition)clazz, label.getNamedArgument()));
            }
            fixes.add(GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(label, clazz));
            this.registerError((PsiElement)label, GroovyBundle.message("no.such.property", label.getName()), fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }

        @Nullable
        private static GrNamedArgumentsOwner getNamedArgumentsOwner(@NotNull GrNewExpression newExpression) {
            GrArgumentList argList;
            if (newExpression == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            if ((argList = newExpression.getArgumentList()) == null) {
                return null;
            }
            GrExpression[] expressionArguments = argList.getExpressionArguments();
            GrNamedArgument[] namedArguments = argList.getNamedArguments();
            if (expressionArguments.length == 1 && namedArguments.length == 0 && expressionArguments[0] instanceof GrListOrMap) {
                return (GrNamedArgumentsOwner)((Object)expressionArguments[0]);
            }
            if (expressionArguments.length == 0) {
                return argList;
            }
            return null;
        }

        private void checkDefaultMapConstructor(GrNamedArgumentsOwner owner, PsiElement element) {
            GrNamedArgument[] args;
            if (owner == null) {
                return;
            }
            for (GrNamedArgument arg : args = owner.getNamedArguments()) {
                PsiElement resolved;
                GrArgumentLabel label = arg.getLabel();
                if (label == null) continue;
                String labelName = label.getName();
                if (labelName == null) {
                    PsiElement nameElement = label.getNameElement();
                    if (nameElement instanceof GrExpression) {
                        PsiType argType = ((GrExpression)nameElement).getType();
                        if (argType == null || TypesUtil.isAssignableByMethodCallConversion((PsiType)TypesUtil.createType("java.lang.String", arg), argType, arg)) continue;
                        this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                        continue;
                    }
                    if ("*".equals(nameElement.getText())) continue;
                    this.registerError(nameElement, GroovyBundle.message("property.name.expected", new Object[0]));
                    continue;
                }
                GroovyPropertyWriteReference propertyReference = label.getConstructorPropertyReference();
                PsiElement psiElement = resolved = propertyReference == null ? null : propertyReference.resolve();
                if (resolved == null) {
                    if (element instanceof PsiMember && !(element instanceof PsiClass)) {
                        element = ((PsiMember)element).getContainingClass();
                    }
                    if (!(element instanceof PsiClass)) continue;
                    this.registerAbsentIdentifierError((PsiClass)element, label);
                    continue;
                }
                if (!(resolved instanceof PsiModifierListOwner) || !((PsiModifierListOwner)resolved).hasModifierProperty("final")) continue;
                this.registerError((PsiElement)label, GroovyBundle.message("inspection.message.property.0.is.final", labelName), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listOrMap";
                    break;
                }
                case 1: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorResolveResult";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedElement";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyConstructorNamedArgumentsInspection$MyVisitor";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyConstructorNamedArgumentsInspection$MyVisitor";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateMapConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitListOrMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNewExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processConstructor";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkGeneratedMapConstructor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generateMapConstructorFix";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "registerAbsentIdentifierError";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getNamedArgumentsOwner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

