/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.fixes.RemoveElementWithoutFormatterFix;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.TokenSetKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Holder", "intellij.groovy.psi"})
public final class GrUnnecessarySemicolonInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.getNode().getElementType() != GroovyElementTypes.T_SEMI || Holder.INSTANCE.isSemicolonNecessary(element)) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{Holder.INSTANCE.getFix()};
                this.$holder.registerProblem(element, GroovyBundle.message("unnecessary.semicolon.description", new Object[0]), localQuickFixArray);
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/style/GrUnnecessarySemicolonInspection$Holder;", "", "()V", "backwardSet", "Lcom/intellij/psi/tree/TokenSet;", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "getFix", "()Lcom/intellij/codeInspection/LocalQuickFix;", "forwardSet", "nlSet", "previousSet", "separators", "isSemicolonNecessary", "", "semicolon", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final LocalQuickFix fix;
        @NotNull
        private static final TokenSet nlSet;
        @NotNull
        private static final TokenSet forwardSet;
        @NotNull
        private static final TokenSet backwardSet;
        @NotNull
        private static final TokenSet separators;
        @NotNull
        private static final TokenSet previousSet;

        private Holder() {
        }

        @NotNull
        public final LocalQuickFix getFix() {
            return fix;
        }

        public final boolean isSemicolonNecessary(@NotNull PsiElement semicolon) {
            Intrinsics.checkNotNullParameter((Object)semicolon, (String)"semicolon");
            if (semicolon.getParent() instanceof GrTraditionalForClause) {
                return true;
            }
            PsiElement psiElement = PsiUtil.skipSet(semicolon, false, backwardSet);
            if (psiElement == null) {
                return false;
            }
            PsiElement prevSibling = psiElement;
            PsiElement psiElement2 = PsiUtil.skipSet(semicolon, true, forwardSet);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement nextSibling = psiElement2;
            IElementType iElementType = prevSibling.getNode().getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"prevSibling.node.elementType");
            IElementType prevType = iElementType;
            return separators.contains(prevType) ? prevSibling.getPrevSibling() instanceof GrEnumConstantList : (previousSet.contains(prevType) ? false : (prevSibling instanceof GrStatement ? nextSibling instanceof GrStatement || nextSibling.getNextSibling() instanceof GrClosableBlock : (prevSibling instanceof GrPackageDefinition || prevSibling instanceof GrImportStatement ? !separators.contains(nextSibling.getNode().getElementType()) : !(prevSibling instanceof GrParameterList) || !(((GrParameterList)prevSibling).getParent() instanceof GrClosableBlock))));
        }

        static {
            String string = GroovyBundle.message("unnecessary.semicolon.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unnecessary.semicolon.fix\")");
            fix = new RemoveElementWithoutFormatterFix(string);
            IElementType[] iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.NL, (String)"NL");
            nlSet = TokenSetKt.TokenSet(iElementTypeArray);
            TokenSet tokenSet = TokenSets.WHITE_SPACES_OR_COMMENTS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACES_OR_COMMENTS");
            iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.T_SEMI, (String)"T_SEMI");
            forwardSet = TokenSetKt.minus(TokenSetKt.plus(tokenSet, TokenSetKt.TokenSet(iElementTypeArray)), nlSet);
            TokenSet tokenSet2 = TokenSets.WHITE_SPACES_OR_COMMENTS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"WHITE_SPACES_OR_COMMENTS");
            backwardSet = TokenSetKt.minus(tokenSet2, nlSet);
            iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.NL, (String)"NL");
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.T_SEMI, (String)"T_SEMI");
            separators = TokenSetKt.TokenSet(iElementTypeArray);
            iElementTypeArray = new IElementType[2];
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.T_LBRACE, (String)"T_LBRACE");
            Intrinsics.checkNotNullExpressionValue((Object)GroovyElementTypes.T_ARROW, (String)"T_ARROW");
            previousSet = TokenSetKt.TokenSet(iElementTypeArray);
        }
    }
}

