/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.OptionsUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class InstrumentationUtils {
    public static final String OBJECT_TYPE = "Ljava/lang/Object;";
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONSTRUCTOR = "<init>";
    public static final String CONSTRUCTOR_DESCRIPTOR = "()V";

    public static void touchById(MethodVisitor mv, int lv, int id) {
        mv.visitVarInsn(25, lv);
        InstrumentationUtils.pushInt(mv, id);
        if (OptionsUtil.CALCULATE_HITS_COUNT) {
            mv.visitInsn(92);
            mv.visitInsn(46);
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitInsn(79);
        } else {
            mv.visitInsn(4);
            mv.visitInsn(79);
        }
    }

    public static int getBytecodeVersion(ClassReader cr) {
        return cr.readInt(4) & 0xFFFF;
    }

    public static void pushInt(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    public static void push(MethodVisitor mv, Object o) {
        if (o == null) {
            mv.visitInsn(1);
        } else if (o instanceof Integer) {
            InstrumentationUtils.pushInt(mv, (Integer)o);
        } else if (o instanceof Boolean) {
            InstrumentationUtils.pushInt(mv, (Boolean)o != false ? 1 : 0);
        } else if (o instanceof Double || o instanceof Float || o instanceof Long || o instanceof String) {
            mv.visitLdcInsn(o);
        } else {
            throw new IllegalArgumentException("Cannot push element of type " + o.getClass());
        }
    }
}

