/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.dataAccess;

import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class FieldCoverageDataAccess
extends CoverageDataAccess {
    private final ExtraFieldInstrumenter myExtraFieldInstrumenter;
    private final CoverageDataAccess.Init myInit;

    public FieldCoverageDataAccess(ClassReader cr, String className, final CoverageDataAccess.Init init) {
        this.myExtraFieldInstrumenter = new ExtraFieldInstrumenter(cr, null, className, init.name, init.desc, true){

            public void initField(MethodVisitor mv) {
                init.loadParams(mv);
                mv.visitMethodInsn(184, init.initOwner, init.initName, init.initDesc, false);
                mv.visitFieldInsn(179, this.getInternalClassName(), init.name, init.desc);
            }
        };
        this.myInit = init;
    }

    public void onMethodStart(MethodVisitor mv, int localVariable) {
        mv.visitFieldInsn(178, this.myExtraFieldInstrumenter.getInternalClassName(), this.myInit.name, this.myInit.desc);
        mv.visitVarInsn(58, localVariable);
    }

    public void onClassEnd(ClassVisitor cv) {
        this.myExtraFieldInstrumenter.generateMembers(cv);
    }

    public MethodVisitor createMethodVisitor(MethodVisitor mv, String name, boolean hasLines) {
        if (hasLines || this.myExtraFieldInstrumenter.isInterface() && "<clinit>".equals(name)) {
            return this.myExtraFieldInstrumenter.createMethodVisitor(mv, name);
        }
        return mv;
    }
}

