/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitOutgoingCommitsProvider;
import git4idea.push.GitPushOptionsPanel;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetPanel;
import git4idea.push.GitPusher;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPushSupport
extends PushSupport<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final Pusher<GitRepository, GitPushSource, GitPushTarget> myPusher;
    @NotNull
    private final OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> myOutgoingCommitsProvider;
    @NotNull
    private final GitVcsSettings mySettings;
    private final GitSharedSettings mySharedSettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    private GitPushSupport(@NotNull Project project) {
        if (project == null) {
            GitPushSupport.$$$reportNull$$$0(0);
        }
        this.myRepositoryManager = GitRepositoryManager.getInstance(project);
        this.myVcs = GitVcs.getInstance(project);
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myPusher = new GitPusher(project, this.mySettings, this);
        this.myOutgoingCommitsProvider = new GitOutgoingCommitsProvider(project);
        this.mySharedSettings = (GitSharedSettings)project.getService(GitSharedSettings.class);
        this.myCommonPushSettings = (PushSettings)project.getService(PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            GitPushSupport.$$$reportNull$$$0(1);
        }
        return gitVcs;
    }

    @NotNull
    public Pusher<GitRepository, GitPushSource, GitPushTarget> getPusher() {
        Pusher<GitRepository, GitPushSource, GitPushTarget> pusher = this.myPusher;
        if (pusher == null) {
            GitPushSupport.$$$reportNull$$$0(2);
        }
        return pusher;
    }

    @NotNull
    public OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> getOutgoingCommitsProvider() {
        OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> outgoingCommitsProvider = this.myOutgoingCommitsProvider;
        if (outgoingCommitsProvider == null) {
            GitPushSupport.$$$reportNull$$$0(3);
        }
        return outgoingCommitsProvider;
    }

    public boolean canBePushed(@NotNull GitRepository repository, @NotNull GitPushSource source, @NotNull GitPushTarget target) {
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(4);
        }
        if (source == null) {
            GitPushSupport.$$$reportNull$$$0(5);
        }
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(6);
        }
        return !repository.isFresh();
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository) {
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(7);
        }
        if (repository.isFresh()) {
            return null;
        }
        GitLocalBranch sourceBranch = repository.getCurrentBranch();
        if (sourceBranch == null) {
            return null;
        }
        return this.getDefaultTarget(repository, GitPushSource.create(sourceBranch));
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository, @NotNull GitPushSource source) {
        GitPushTarget pushSpecTarget;
        GitLocalBranch sourceBranch;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(8);
        }
        if (source == null) {
            GitPushSupport.$$$reportNull$$$0(9);
        }
        if ((sourceBranch = source.getBranch()) != null && (pushSpecTarget = GitPushSupport.getPushTargetIfExist(repository, sourceBranch)) != null) {
            return pushSpecTarget;
        }
        GitRemote remote = GitUtil.getDefaultOrFirstRemote(repository.getRemotes());
        if (remote == null) {
            return null;
        }
        if (sourceBranch != null) {
            return GitPushSupport.makeTargetForNewBranch(repository, remote, sourceBranch.getName());
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch != null) {
            return GitPushSupport.makeTargetForNewBranch(repository, remote, currentBranch.getName());
        }
        Set remoteBranches2 = ContainerUtil.map2SetNotNull(repository.getBranches().getRemoteBranches(), branch -> branch.getRemote().equals(remote) ? branch.getNameForRemoteOperations() : null);
        String newBranchName = UniqueNameGenerator.generateUniqueName((String)"detached", (String)"", (String)"", (Collection)remoteBranches2);
        return GitPushSupport.makeTargetForNewBranch(repository, remote, newBranchName);
    }

    @Nullable
    public static GitPushTarget getPushTargetIfExist(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch) {
        GitPushTarget pushSpecTarget;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(10);
        }
        if (localBranch == null) {
            GitPushSupport.$$$reportNull$$$0(11);
        }
        if ((pushSpecTarget = GitPushTarget.getFromPushSpec(repository, localBranch)) != null) {
            return pushSpecTarget;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, localBranch);
        if (trackInfo != null) {
            return new GitPushTarget(trackInfo.getRemoteBranch(), false);
        }
        return null;
    }

    @NotNull
    private static GitPushTarget makeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        GitRemoteBranch existingRemoteBranch;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(12);
        }
        if (remote == null) {
            GitPushSupport.$$$reportNull$$$0(13);
        }
        if (branchName == null) {
            GitPushSupport.$$$reportNull$$$0(14);
        }
        if ((existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName)) != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        return new GitPushTarget(new GitStandardRemoteBranch(remote, branchName), true);
    }

    @NotNull
    public GitPushSource getSource(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(15);
        }
        GitPushSource gitPushSource = (currentBranch = repository.getCurrentBranch()) != null ? GitPushSource.create(currentBranch) : GitPushSource.createDetached(Objects.requireNonNull(repository.getCurrentRevision()));
        if (gitPushSource == null) {
            GitPushSupport.$$$reportNull$$$0(16);
        }
        return gitPushSource;
    }

    @NotNull
    public RepositoryManager<GitRepository> getRepositoryManager() {
        GitRepositoryManager gitRepositoryManager = this.myRepositoryManager;
        if (gitRepositoryManager == null) {
            GitPushSupport.$$$reportNull$$$0(17);
        }
        return gitRepositoryManager;
    }

    @NotNull
    public PushTargetPanel<GitPushTarget> createTargetPanel(@NotNull GitRepository repository, @NotNull GitPushSource source, @Nullable GitPushTarget defaultTarget) {
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(18);
        }
        if (source == null) {
            GitPushSupport.$$$reportNull$$$0(19);
        }
        return new GitPushTargetPanel(this, repository, source, defaultTarget);
    }

    public boolean isForcePushAllowed(@NotNull GitRepository repo, @NotNull GitPushTarget target) {
        String targetBranch;
        if (repo == null) {
            GitPushSupport.$$$reportNull$$$0(20);
        }
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(21);
        }
        return !this.mySharedSettings.isBranchProtected(targetBranch = target.getBranch().getNameForRemoteOperations());
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new GitPushOptionsPanel(this.mySettings.getPushTagMode(), GitVersionSpecialty.SUPPORTS_FOLLOW_TAGS.existsIn(this.myVcs), this.shouldShowSkipHookOption());
    }

    private boolean shouldShowSkipHookOption() {
        return GitVersionSpecialty.PRE_PUSH_HOOK.existsIn(this.myVcs) && this.getRepositoryManager().getRepositories().stream().map(e -> e.getInfo().getHooksInfo()).anyMatch(GitHooksInfo::isPrePushHookAvailable);
    }

    public boolean isSilentForcePushAllowed(@NotNull GitPushTarget target) {
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(22);
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public void saveSilentForcePushTarget(@NotNull GitPushTarget target) {
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(23);
        }
        this.myCommonPushSettings.addForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public boolean mayChangeTargetsSync() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushSupport";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingCommitsProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBePushed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTarget";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPushTargetIfExist";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeTargetForNewBranch";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSource";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTargetPanel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isForcePushAllowed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSilentForcePushAllowed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveSilentForcePushTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 16, 17 -> new IllegalStateException(string);
        };
    }
}

