/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageManagerKt;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GitVFSListener
extends VcsVFSListener {
    private GitVFSListener(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(0);
        }
        super((AbstractVcs)vcs);
    }

    @NotNull
    public static GitVFSListener createInstance(@NotNull GitVcs vcs, @NotNull Disposable disposable) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            GitVFSListener.$$$reportNull$$$0(2);
        }
        GitVFSListener listener2 = new GitVFSListener(vcs);
        Disposer.register((Disposable)disposable, (Disposable)listener2);
        listener2.installListeners();
        GitVFSListener gitVFSListener = listener2;
        if (gitVFSListener == null) {
            GitVFSListener.$$$reportNull$$$0(3);
        }
        return gitVFSListener;
    }

    @NotNull
    protected String getAddTitle() {
        String string = GitBundle.message("vfs.listener.add.title", new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = GitBundle.message("vfs.listener.add.single.title", new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = GitBundle.message("vfs.listener.add.single.prompt", new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFiles) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(7);
        }
        if (copiedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(8);
        }
        this.executeAddWithoutIgnores(addedFiles, copiedFiles, (notIgnoredAddedFiles, copiedFilesMap) -> this.originalExecuteAdd(notIgnoredAddedFiles, copiedFilesMap));
    }

    protected void executeAddWithoutIgnores(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap, final @NotNull VcsVFSListener.ExecuteAddCallback executeAddCallback) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(9);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(10);
        }
        if (executeAddCallback == null) {
            GitVFSListener.$$$reportNull$$$0(11);
        }
        this.saveUnsavedVcsIgnoreFiles();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.message("vfs.listener.checking.ignored", new Object[0]), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map<VirtualFile, List<VirtualFile>> sortedFiles = GitUtil.sortFilesByGitRootIgnoringMissing(this.myProject, addedFiles);
                HashSet<VirtualFile> retainedFiles = new HashSet<VirtualFile>();
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(Git.getInstance().untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> executeAddCallback.executeAdd(addedFiles, copyFromMap));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
            }
        });
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(12);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(13);
        }
        this.performAdding(ContainerUtil.map(addedFiles, VcsUtil::getFilePath));
    }

    private void performAdding(Collection<? extends FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.message("add.adding", new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (GitVFSListener.this.isStageEnabled()) {
                    GitVFSListener.this.executeAddingToIndex(root, files);
                } else {
                    GitVFSListener.this.executeAdding(root, files);
                }
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = GitBundle.message("vfs.listener.delete.title", new Object[0]);
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.message("vfs.listener.delete.single.title", new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.message("vfs.listener.delete.single.prompt", new Object[0]);
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            GitVFSListener.$$$reportNull$$$0(15);
        }
        this.performBackgroundOperation(filesToDelete, GitBundle.message("remove.removing", new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    3.$$$reportNull$$$0(1);
                }
                GitVFSListener.this.executeDeletion(root, files);
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        Collection<FilePath> selectedToRemove;
        List<Object> selectedToAdd;
        if (movedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(16);
        }
        ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        ArrayList<FilePath> toRemove = new ArrayList<FilePath>();
        final ArrayList<VcsVFSListener.MovedFileInfo> toForceMove = new ArrayList<VcsVFSListener.MovedFileInfo>();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!movedInfo.isCaseSensitive() && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(VcsUtil.getFilePath((String)oldPath));
            toAdd.add(VcsUtil.getFilePath((String)newPath));
        }
        if (this.isStageEnabled()) {
            selectedToAdd = this.selectFilePathsToAdd(toAdd);
            selectedToRemove = this.selectFilePathsToDelete(toRemove);
        } else if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myRemoveOption.getValue()) && VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myAddOption.getValue())) {
            selectedToAdd = Collections.emptyList();
            selectedToRemove = Collections.emptyList();
        } else {
            selectedToAdd = toAdd;
            selectedToRemove = toRemove;
        }
        if (toAdd.isEmpty() && toRemove.isEmpty() && toForceMove.isEmpty()) {
            return;
        }
        LOG.debug("performMoveRename. \ntoAdd: " + toAdd + "\ntoRemove: " + toRemove + "\ntoForceMove: " + toForceMove);
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, GitBundle.message("progress.title.moving.files", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    ArrayList<FilePath> dirtyPaths = new ArrayList<FilePath>();
                    ArrayList<File> toRefresh = new ArrayList<File>();
                    for (Map.Entry<VirtualFile, List<FilePath>> toAddEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToAdd).entrySet()) {
                        List<FilePath> files = toAddEntry.getValue();
                        GitVFSListener.this.executeAdding(toAddEntry.getKey(), files);
                        dirtyPaths.addAll(files);
                    }
                    for (Map.Entry<VirtualFile, List<FilePath>> toRemoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToRemove).entrySet()) {
                        List<FilePath> paths = toRemoveEntry.getValue();
                        GitVFSListener.this.executeDeletion(toRemoveEntry.getKey(), paths);
                        dirtyPaths.addAll(paths);
                    }
                    Map filesToForceMove = ContainerUtil.map2Map((Collection)toForceMove, info -> Pair.create((Object)VcsUtil.getFilePath((String)info.myNewPath), (Object)info));
                    dirtyPaths.addAll(ContainerUtil.map((Collection)toForceMove, fileInfo -> VcsUtil.getFilePath((String)fileInfo.myOldPath)));
                    for (Map.Entry<VirtualFile, List<FilePath>> toForceMoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filesToForceMove.keySet()).entrySet()) {
                        List<FilePath> paths = toForceMoveEntry.getValue();
                        toRefresh.addAll(GitVFSListener.this.executeForceMove(toForceMoveEntry.getKey(), paths, filesToForceMove));
                        dirtyPaths.addAll(paths);
                    }
                    VcsFileUtil.markFilesDirty((Project)this.myProject, dirtyPaths);
                    RefreshVFsSynchronously.refreshFiles(toRefresh);
                }
                catch (VcsException ex) {
                    GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$4", "run"));
            }
        });
    }

    private void executeAdding(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(17);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(18);
        }
        LOG.debug("Git: adding files: " + files);
        GitFileUtils.addPaths(this.myProject, root, files, false, false);
    }

    private void executeAddingToIndex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(19);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(20);
        }
        LOG.debug("Git: adding files to index: " + files);
        GitFileUtils.addPathsToIndex(this.myProject, root, files);
    }

    private void executeDeletion(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(21);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(22);
        }
        GitFileUtils.deletePaths(this.myProject, root, files, "--ignore-unmatch", "--cached", "-r");
    }

    private Set<File> executeForceMove(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, @NotNull Map<FilePath, VcsVFSListener.MovedFileInfo> filesToMove) {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(23);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(24);
        }
        if (filesToMove == null) {
            GitVFSListener.$$$reportNull$$$0(25);
        }
        HashSet<File> toRefresh = new HashSet<File>();
        for (FilePath filePath : files) {
            VcsVFSListener.MovedFileInfo info = filesToMove.get(filePath);
            GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.MV);
            h.addParameters("-f");
            h.addRelativePaths(VcsUtil.getFilePath((String)info.myOldPath), VcsUtil.getFilePath((String)info.myNewPath));
            Git.getInstance().runCommand(h);
            toRefresh.add(new File(info.myOldPath));
            toRefresh.add(new File(info.myNewPath));
        }
        return toRefresh;
    }

    private boolean isStageEnabled() {
        return GitStageManagerKt.isStagingAreaAvailable(this.myProject);
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected boolean isRecursiveDeleteSupported() {
        return true;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return false;
    }

    @NotNull
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(26);
        }
        if (this.isStageEnabled()) {
            Collection collection = super.selectFilePathsToDelete(deletedFiles);
            if (collection == null) {
                GitVFSListener.$$$reportNull$$$0(27);
            }
            return collection;
        }
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)this.myRemoveOption.getValue())) {
            List<FilePath> list2 = Collections.emptyList();
            if (list2 == null) {
                GitVFSListener.$$$reportNull$$$0(28);
            }
            return list2;
        }
        List<FilePath> list3 = deletedFiles;
        if (list3 == null) {
            GitVFSListener.$$$reportNull$$$0(29);
        }
        return list3;
    }

    private void performBackgroundOperation(final @NotNull Collection<? extends FilePath> files, @NotNull @NlsContexts.ProgressTitle String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(30);
        }
        if (operationTitle == null) {
            GitVFSListener.$$$reportNull$$$0(31);
        }
        if (executor == null) {
            GitVFSListener.$$$reportNull$$$0(32);
        }
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, files).forEach((root, filePaths) -> {
                    try {
                        executor.execute((VirtualFile)root, (List<? extends FilePath>)filePaths);
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$5", "run"));
            }
        });
    }

    @TestOnly
    public void waitForExternalFilesEventsProcessedInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myExternalFilesProcessor.waitForEventsProcessedInTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 14, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFiles";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeAddCallback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToMove";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFilePathsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAddWithoutIgnores";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "executeAdding";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "executeAddingToIndex";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeDeletion";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "executeForceMove";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "performBackgroundOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 14, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<? extends FilePath> var2) throws VcsException;
    }
}

