/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bB+\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\bJ\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c2\u0003J5\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/name/CallableId;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "callableName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/Name;)V", "packageName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "pathToLocal", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/FqName;)V", "className", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/FqName;)V", "getCallableName", "()Lorg/jetbrains/kotlin/name/Name;", "<set-?>", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "isLocal", "", "()Z", "getPackageName", "asFqNameForDebugInfo", "asSingleFqName", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "compiler.common"})
public final class CallableId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final FqName pathToLocal;
    @Nullable
    private ClassId classId;
    @NotNull
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;

    public CallableId(@NotNull FqName packageName, @Nullable FqName className2, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        this.packageName = packageName;
        this.className = className2;
        this.callableName = callableName;
        this.pathToLocal = pathToLocal;
    }

    public /* synthetic */ CallableId(FqName fqName, FqName fqName2, Name name, FqName fqName3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fqName3 = null;
        }
        this(fqName, fqName2, name, fqName3);
    }

    @NotNull
    public final FqName getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final FqName getClassName() {
        return this.className;
    }

    @NotNull
    public final Name getCallableName() {
        return this.callableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLocal() {
        if (Intrinsics.areEqual((Object)this.packageName, (Object)PACKAGE_FQ_NAME_FOR_LOCAL)) return true;
        ClassId classId = this.getClassId();
        if (classId == null) return false;
        if (!classId.isLocal()) return false;
        return true;
    }

    @Nullable
    public final ClassId getClassId() {
        if (this.classId == null && this.className != null) {
            this.classId = new ClassId(this.packageName, this.className, Intrinsics.areEqual((Object)this.packageName, (Object)PACKAGE_FQ_NAME_FOR_LOCAL));
        }
        return this.classId;
    }

    public CallableId(@NotNull ClassId classId, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getPackageFqName(...)");
        this(fqName, classId.getRelativeClassName(), callableName, null, 8, null);
        this.classId = classId;
    }

    public CallableId(@NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        this(packageName, null, callableName, null, 8, null);
    }

    public CallableId(@NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        this(PACKAGE_FQ_NAME_FOR_LOCAL, null, callableName, pathToLocal);
    }

    public /* synthetic */ CallableId(Name name, FqName fqName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fqName = null;
        }
        this(name, fqName);
    }

    @NotNull
    public final FqName asFqNameForDebugInfo() {
        if (this.pathToLocal != null) {
            FqName fqName = this.pathToLocal.child(this.callableName);
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
            return fqName;
        }
        return this.asSingleFqName();
    }

    @NotNull
    public final FqName asSingleFqName() {
        FqName fqName;
        Object object = this.getClassId();
        if ((object != null && (object = ((ClassId)object).asSingleFqName()) != null ? ((FqName)object).child(this.callableName) : (fqName = null)) == null) {
            FqName fqName2 = this.packageName.child(this.callableName);
            fqName = fqName2;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        }
        return fqName;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = this.packageName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        $this$toString_u24lambda_u240.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null));
        $this$toString_u24lambda_u240.append("/");
        if (this.className != null) {
            $this$toString_u24lambda_u240.append(this.className);
            $this$toString_u24lambda_u240.append(".");
        }
        $this$toString_u24lambda_u240.append(this.callableName);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final FqName component1() {
        return this.packageName;
    }

    @Nullable
    public final FqName component2() {
        return this.className;
    }

    @NotNull
    public final Name component3() {
        return this.callableName;
    }

    private final FqName component4() {
        return this.pathToLocal;
    }

    @NotNull
    public final CallableId copy(@NotNull FqName packageName, @Nullable FqName className2, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        return new CallableId(packageName, className2, callableName, pathToLocal);
    }

    public static /* synthetic */ CallableId copy$default(CallableId callableId, FqName fqName, FqName fqName2, Name name, FqName fqName3, int n, Object object) {
        if ((n & 1) != 0) {
            fqName = callableId.packageName;
        }
        if ((n & 2) != 0) {
            fqName2 = callableId.className;
        }
        if ((n & 4) != 0) {
            name = callableId.callableName;
        }
        if ((n & 8) != 0) {
            fqName3 = callableId.pathToLocal;
        }
        return callableId.copy(fqName, fqName2, name, fqName3);
    }

    public int hashCode() {
        int result2 = this.packageName.hashCode();
        result2 = result2 * 31 + (this.className == null ? 0 : this.className.hashCode());
        result2 = result2 * 31 + this.callableName.hashCode();
        result2 = result2 * 31 + (this.pathToLocal == null ? 0 : this.pathToLocal.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallableId)) {
            return false;
        }
        CallableId callableId = (CallableId)other;
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)callableId.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.className, (Object)callableId.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.callableName, (Object)callableId.callableName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pathToLocal, (Object)callableId.pathToLocal);
    }

    static {
        FqName fqName = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"topLevel(...)");
        PACKAGE_FQ_NAME_FOR_LOCAL = fqName;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/name/CallableId$Companion;", "", "()V", "LOCAL_NAME", "Lorg/jetbrains/kotlin/name/Name;", "PACKAGE_FQ_NAME_FOR_LOCAL", "Lorg/jetbrains/kotlin/name/FqName;", "getPACKAGE_FQ_NAME_FOR_LOCAL", "()Lorg/jetbrains/kotlin/name/FqName;", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getPACKAGE_FQ_NAME_FOR_LOCAL() {
            return PACKAGE_FQ_NAME_FOR_LOCAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

