/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40;

import com.intellij.maven.server.m40.utils.Maven40ApiModelConverter;
import com.intellij.maven.server.m40.utils.Maven40EffectivePomDumper;
import com.intellij.maven.server.m40.utils.Maven40ExecutionResult;
import com.intellij.maven.server.m40.utils.Maven40ImporterSpy;
import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ProjectResolver;
import com.intellij.maven.server.m40.utils.Maven40ServerConsoleLogger;
import com.intellij.maven.server.m40.utils.Maven40SettingsBuilder;
import com.intellij.maven.server.m40.utils.Maven40Sl4jLoggerWrapper;
import com.intellij.maven.server.m40.utils.Maven40TransferListenerAdapter;
import com.intellij.maven.server.m40.utils.RemoteNativeMaven40ProjectHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtilRt;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Node;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.DefaultSessionFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.SettingsBuilder;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenCoreInitializationException;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenGoalExecutionRequest;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.MavenServerEmbeddedBase;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.ParallelRunner;
import org.jetbrains.idea.maven.server.PluginResolutionRequest;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.server.ProjectResolutionRequest;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class Maven40ServerEmbedderImpl
extends MavenServerEmbeddedBase {
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final Maven40ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private final boolean myAlwaysUpdateSnapshots;
    @NotNull
    private final MavenRepositorySystem myRepositorySystem;
    @NotNull
    private final Maven40ImporterSpy myImporterSpy;
    @NotNull
    protected final MavenEmbedderSettings myEmbedderSettings;

    public Maven40ServerEmbedderImpl(MavenEmbedderSettings settings) {
        Object cliRequest;
        Class<?> cliRequestClass;
        this.myEmbedderSettings = settings;
        String multiModuleProjectDirectory = settings.getMultiModuleProjectDirectory();
        if (multiModuleProjectDirectory != null) {
            System.setProperty("user.dir", multiModuleProjectDirectory);
            System.setProperty("maven.multiModuleProjectDirectory", multiModuleProjectDirectory);
        } else {
            System.setProperty("maven.multiModuleProjectDirectory", "");
        }
        MavenServerSettings serverSettings = settings.getSettings();
        String mavenHome = serverSettings.getMavenHomePath();
        if (mavenHome != null) {
            System.setProperty("maven.home", mavenHome);
        }
        this.myConsoleWrapper = new Maven40ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(serverSettings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven40ServerEmbedderImpl.this.myConsoleWrapper;
                    }
                });
            }
        };
        DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.CliRequest");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unable to find maven CliRequest class");
        }
        try {
            List<String> commandLineOptions = Maven40ServerEmbedderImpl.createCommandLineOptions(serverSettings);
            this.myAlwaysUpdateSnapshots = commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots");
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions.toArray(new String[0]), classWorld);
            for (String each : new String[]{"initialize", "cli", "logging", "properties"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (Exception e) {
            ParseException cause = (ParseException)ExceptionUtilRt.findCause((Throwable)e, ParseException.class);
            if (cause != null) {
                String workingDir = settings.getMultiModuleProjectDirectory();
                if (workingDir == null) {
                    workingDir = System.getProperty("user.dir");
                }
                throw new MavenConfigParseException(cause.getMessage(), workingDir);
            }
            throw new RuntimeException(e);
        }
        try {
            Method m = MavenCli.class.getDeclaredMethod("container", cliRequestClass);
            m.setAccessible(true);
            this.myContainer = (DefaultPlexusContainer)m.invoke((Object)cli, cliRequest);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException().getClass().getCanonicalName().equals("org.apache.maven.cli.internal.ExtensionResolutionException")) {
                MavenId id = this.extractIdFromException(((InvocationTargetException)e).getTargetException());
                throw new MavenCoreInitializationException((Throwable)this.wrapToSerializableRuntimeException(((InvocationTargetException)e).getTargetException()), id);
            }
            throw this.wrapToSerializableRuntimeException(e);
        }
        this.myContainer.getLoggerManager().setThreshold(serverSettings.getLoggingLevel());
        this.mySystemProperties = (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"systemProperties");
        if (serverSettings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", serverSettings.getProjectJdk());
        }
        this.myMavenSettings = Maven40SettingsBuilder.buildSettings((SettingsBuilder)settingsBuilder, serverSettings, this.mySystemProperties, (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"userProperties"));
        this.myRepositorySystem = this.getComponent(MavenRepositorySystem.class);
        Maven40ImporterSpy importerSpy = this.getComponentIfExists(Maven40ImporterSpy.class);
        if (importerSpy == null) {
            importerSpy = new Maven40ImporterSpy();
            this.myContainer.addComponent((Object)importerSpy, Maven40ImporterSpy.class.getName());
        }
        this.myImporterSpy = importerSpy;
    }

    @NotNull
    private static List<String> createCommandLineOptions(MavenServerSettings serverSettings) {
        ArrayList<String> commandLineOptions = new ArrayList<String>(serverSettings.getUserProperties().size());
        for (Map.Entry<Object, Object> each : serverSettings.getUserProperties().entrySet()) {
            commandLineOptions.add("-D" + each.getKey() + "=" + each.getValue());
        }
        if (serverSettings.getLocalRepositoryPath() != null) {
            commandLineOptions.add("-Dmaven.repo.local=" + serverSettings.getLocalRepositoryPath());
        }
        if (serverSettings.isUpdateSnapshots()) {
            commandLineOptions.add("-U");
        }
        if (serverSettings.getLoggingLevel() == 0) {
            commandLineOptions.add("-X");
            commandLineOptions.add("-e");
        } else if (serverSettings.getLoggingLevel() == 5) {
            commandLineOptions.add("-q");
        }
        String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
        if (mavenEmbedderCliOptions != null) {
            commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
        }
        if (serverSettings.getGlobalSettingsPath() != null) {
            commandLineOptions.add("-gs");
            commandLineOptions.add(serverSettings.getGlobalSettingsPath());
        }
        if (serverSettings.getUserSettingsPath() != null) {
            commandLineOptions.add("-s");
            commandLineOptions.add(serverSettings.getUserSettingsPath());
        }
        if (serverSettings.isOffline()) {
            commandLineOptions.add("-o");
        }
        ArrayList<String> arrayList = commandLineOptions;
        if (arrayList == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public Collection<MavenServerExecutionResult> resolveProjects(@NotNull String longRunningTaskId, @NotNull ProjectResolutionRequest request, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(1);
        }
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(2);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        List files = request.getPomFiles();
        List activeProfiles = request.getActiveProfiles();
        List inactiveProfiles = request.getInactiveProfiles();
        MavenWorkspaceMap workspaceMap = request.getWorkspaceMap();
        boolean updateSnapshots = this.myAlwaysUpdateSnapshots || request.updateSnapshots();
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, files.size(), this.myConsoleWrapper);
        Maven40ProjectResolver projectResolver = new Maven40ProjectResolver(this, updateSnapshots, this.myImporterSpy, task.getIndicator(), workspaceMap, this.getLocalRepositoryFile());
        this.customizeComponents(workspaceMap);
        Collection<MavenServerExecutionResult> collection = projectResolver.resolveProjects(task, files, activeProfiles, inactiveProfiles);
        this.resetComponents();
        Collection<MavenServerExecutionResult> collection2 = collection;
        if (collection2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(3);
        }
        return collection2;
        {
            catch (Throwable throwable) {
                this.resetComponents();
                throw throwable;
            }
        }
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private File getLocalRepositoryFile() {
        return new File(this.myEmbedderSettings.getSettings().getLocalRepositoryPath());
    }

    public void collectProblems(@Nullable File file, @NotNull Collection<? extends Exception> exceptions, @NotNull List<? extends ModelProblem> modelProblems, @NotNull Collection<? super MavenProjectProblem> collector) {
        if (exceptions == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(4);
        }
        if (modelProblems == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(6);
        }
        for (Throwable throwable : exceptions) {
            collector.addAll(this.collectExceptionProblems(file, throwable));
        }
        for (ModelProblem modelProblem : modelProblems) {
            String source = !StringUtilRt.isEmptyOrSpaces((CharSequence)modelProblem.getSource()) ? modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber() : (file == null ? "" : file.getPath());
            this.myConsoleWrapper.error("Maven model problem: " + modelProblem.getMessage() + " at " + modelProblem.getSource() + ":" + modelProblem.getLineNumber() + ":" + modelProblem.getColumnNumber());
            Exception problemException = modelProblem.getException();
            if (problemException != null) {
                List<MavenProjectProblem> exceptionProblems = this.collectExceptionProblems(file, problemException);
                if (exceptionProblems.isEmpty()) {
                    this.myConsoleWrapper.error("Maven model problem", problemException);
                    collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage()));
                    continue;
                }
                collector.addAll(exceptionProblems);
                continue;
            }
            collector.add((MavenProjectProblem)MavenProjectProblem.createStructureProblem((String)source, (String)modelProblem.getMessage(), (boolean)true));
        }
    }

    private List<MavenProjectProblem> collectExceptionProblems(@Nullable File file, Throwable ex) {
        String path;
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        if (ex == null) {
            return result;
        }
        MavenServerGlobals.getLogger().print(ExceptionUtils.getFullStackTrace((Throwable)ex));
        this.myConsoleWrapper.info("Validation error:", ex);
        Artifact problemTransferArtifact = Maven40ServerEmbedderImpl.getProblemTransferArtifact(ex);
        if (ex instanceof IllegalStateException && ex.getCause() != null) {
            ex = ex.getCause();
        }
        String string = path = file == null ? "" : file.getPath();
        if (path.isEmpty() && ex instanceof ProjectBuildingException) {
            File pomFile = ((ProjectBuildingException)ex).getPomFile();
            String string2 = path = pomFile == null ? "" : pomFile.getPath();
        }
        if (ex instanceof ProjectBuildingException) {
            String causeMessage = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
        } else if (ex.getStackTrace().length > 0 && ex.getClass().getPackage().getName().equals("groovy.lang")) {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            StackTraceElement traceElement = ex.getStackTrace()[0];
            result.add(MavenProjectProblem.createStructureProblem((String)(traceElement.getFileName() + ":" + traceElement.getLineNumber()), (String)ex.getMessage()));
        } else if (problemTransferArtifact != null) {
            this.myConsoleWrapper.error("[server] Maven transfer artifact problem: " + problemTransferArtifact);
            String message = Maven40ServerEmbedderImpl.getRootMessage(ex);
            MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(problemTransferArtifact, this.getLocalRepositoryFile());
            result.add(MavenProjectProblem.createRepositoryProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
        } else {
            this.myConsoleWrapper.error("Maven server structure problem", ex);
            result.add(MavenProjectProblem.createStructureProblem((String)path, (String)Maven40ServerEmbedderImpl.getRootMessage(ex), (boolean)true));
        }
        return result;
    }

    @NotNull
    public static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = StringUtils.isNotEmpty((String)rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static Artifact getProblemTransferArtifact(Throwable each) {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)each);
        if (throwables == null) {
            return null;
        }
        for (Throwable throwable : throwables) {
            if (!(throwable instanceof ArtifactTransferException)) continue;
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)((ArtifactTransferException)throwable).getArtifact());
        }
        return null;
    }

    private <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getComponentIfExists(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private <T> T getComponentIfExists(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private MavenId extractIdFromException(Throwable exception) {
        try {
            Field field = exception.getClass().getDeclaredField("extension");
            field.setAccessible(true);
            CoreExtension extension = (CoreExtension)field.get(exception);
            return new MavenId(extension.getGroupId(), extension.getArtifactId(), extension.getVersion());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles) {
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.injectDefaultRepositories((MavenExecutionRequest)result);
            this.injectDefaultPluginRepositories((MavenExecutionRequest)result);
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            Properties userProperties = new Properties();
            if (file != null) {
                userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigProperties((File)file.getParentFile()));
            }
            result.setUserProperties(userProperties);
            result.setActiveProfiles(Maven40ServerEmbedderImpl.collectActiveProfiles(result.getActiveProfiles(), activeProfiles, inactiveProfiles));
            if (inactiveProfiles != null) {
                result.setInactiveProfiles(inactiveProfiles);
            }
            result.setCacheNotFound(true);
            result.setCacheTransferError(true);
            result.setStartTime(new Date());
            File mavenMultiModuleProjectDirectory = Maven40ServerEmbedderImpl.getMultimoduleProjectDir(file);
            result.setBaseDirectory(mavenMultiModuleProjectDirectory);
            result.setMultiModuleProjectDirectory(mavenMultiModuleProjectDirectory);
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectDefaultRepositories(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        Set definedRepositories = this.myRepositorySystem.getRepoIds(request.getRemoteRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addRemoteRepository(this.myRepositorySystem.createDefaultRemoteRepository(request));
            }
            catch (Exception e) {
                throw new MavenExecutionRequestPopulationException("Cannot create default remote repository.", (Throwable)e);
            }
        }
    }

    private void injectDefaultPluginRepositories(MavenExecutionRequest request) throws MavenExecutionRequestPopulationException {
        Set definedRepositories = this.myRepositorySystem.getRepoIds(request.getPluginArtifactRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addPluginArtifactRepository(this.myRepositorySystem.createDefaultRemoteRepository(request));
            }
            catch (Exception e) {
                throw new MavenExecutionRequestPopulationException("Cannot create default remote repository.", (Throwable)e);
            }
        }
    }

    @NotNull
    private static File getMultimoduleProjectDir(@Nullable File file) {
        File mavenMultiModuleProjectDirectory = file == null ? new File(FileUtilRt.getTempDirectory()) : MavenServerUtil.findMavenBasedir((File)file);
        File file2 = mavenMultiModuleProjectDirectory;
        if (file2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(8);
        }
        return file2;
    }

    private static List<String> collectActiveProfiles(@Nullable List<String> defaultActiveProfiles, @Nullable List<String> explicitActiveProfiles, @Nullable List<String> explicitInactiveProfiles) {
        if (defaultActiveProfiles == null || defaultActiveProfiles.isEmpty()) {
            return explicitActiveProfiles != null ? explicitActiveProfiles : Collections.emptyList();
        }
        HashSet<String> result = new HashSet<String>(defaultActiveProfiles);
        if (explicitInactiveProfiles != null && !explicitInactiveProfiles.isEmpty()) {
            result.removeAll(explicitInactiveProfiles);
        }
        if (explicitActiveProfiles != null) {
            result.addAll(explicitActiveProfiles);
        }
        return new ArrayList<String>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithMavenSession(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        SessionScope sessionScope = this.getComponent(SessionScope.class);
        sessionScope.enter();
        try {
            MavenSession mavenSession = this.createMavenSession(request, maven);
            sessionScope.seed(MavenSession.class, (Object)mavenSession);
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession oldSession = legacySupport.getSession();
            legacySupport.setSession(mavenSession);
            this.notifyAfterSessionStart(mavenSession);
            try {
                runnable.run();
            }
            finally {
                legacySupport.setSession(oldSession);
            }
        }
        finally {
            sessionScope.exit();
        }
    }

    private void notifyAfterSessionStart(MavenSession mavenSession) {
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven40ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven40ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static void warn(String message, Throwable e) {
        MavenServerGlobals.getLogger().warn((Throwable)new RuntimeException(message, e));
    }

    private PlexusContainer getContainer() {
        return this.myContainer;
    }

    @NotNull
    private MavenSession createMavenSession(MavenExecutionRequest request, DefaultMaven maven) {
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        return new MavenSession(this.getContainer(), repositorySession, request, (MavenExecutionResult)new DefaultMavenExecutionResult());
    }

    public List<PluginResolutionResponse> resolvePlugins(@NotNull String longRunningTaskId, @NotNull Collection<PluginResolutionRequest> pluginResolutionRequests, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(9);
        }
        if (pluginResolutionRequests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(10);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        boolean runInParallel = false;
        try (LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pluginResolutionRequests.size(), this.myConsoleWrapper);){
            List results;
            MavenExecutionRequest request = this.createRequest(null, null, null);
            request.setTransferListener((TransferListener)new Maven40TransferListenerAdapter(task.getIndicator()));
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession session = maven.newRepositorySession(request);
            this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)task.getIndicator());
            ArrayList<PluginResolutionData> resolutions = new ArrayList<PluginResolutionData>();
            for (PluginResolutionRequest pluginResolutionRequest : pluginResolutionRequests) {
                MavenId mavenPluginId = pluginResolutionRequest.getMavenPluginId();
                int nativeMavenProjectId = pluginResolutionRequest.getNativeMavenProjectId();
                String groupId = mavenPluginId.getGroupId();
                String artifactId = mavenPluginId.getArtifactId();
                MavenProject project = RemoteNativeMaven40ProjectHolder.findProjectById(nativeMavenProjectId);
                List remoteRepos = project.getRemotePluginRepositories();
                Plugin pluginFromProject = (Plugin)project.getBuild().getPluginsAsMap().get(groupId + ':' + artifactId);
                List pluginDependencies = null == pluginFromProject ? Collections.emptyList() : pluginFromProject.getDependencies();
                PluginResolutionData resolution2 = new PluginResolutionData(mavenPluginId, pluginDependencies, remoteRepos);
                resolutions.add(resolution2);
            }
            List list = results = ParallelRunner.execute((boolean)runInParallel, resolutions, resolution -> this.resolvePlugin(task, resolution.mavenPluginId, resolution.pluginDependencies, resolution.remoteRepos, session));
            return list;
        }
    }

    @NotNull
    private PluginResolutionResponse resolvePlugin(LongRunningTask task, MavenId mavenPluginId, List<Dependency> pluginDependencies, List<RemoteRepository> remoteRepos, RepositorySystemSession session) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (task.isCanceled()) {
            return new PluginResolutionResponse(mavenPluginId, false, artifacts);
        }
        try {
            Plugin plugin = new Plugin();
            plugin.setGroupId(mavenPluginId.getGroupId());
            plugin.setArtifactId(mavenPluginId.getArtifactId());
            plugin.setVersion(mavenPluginId.getVersion());
            plugin.setDependencies(pluginDependencies);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            org.eclipse.aether.artifact.Artifact pluginArtifact = pluginDependenciesResolver.resolve(plugin, remoteRepos, session);
            DependencyNode node = pluginDependenciesResolver.resolve(plugin, pluginArtifact, null, remoteRepos, session);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (org.eclipse.aether.artifact.Artifact artifact : nlg.getArtifacts(true)) {
                if (Objects.equals(artifact.getArtifactId(), plugin.getArtifactId()) && Objects.equals(artifact.getGroupId(), plugin.getGroupId())) continue;
                artifacts.add(Maven40ModelConverter.convertArtifact(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact), this.getLocalRepositoryFile()));
            }
            task.incrementFinishedRequests();
            return new PluginResolutionResponse(mavenPluginId, true, artifacts);
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            return new PluginResolutionResponse(mavenPluginId, false, artifacts);
        }
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, MavenToken token) {
        if (file == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(11);
        }
        if (activeProfiles == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(12);
        }
        if (inactiveProfiles == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(13);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return Maven40EffectivePomDumper.evaluateEffectivePom(this, file, activeProfiles, inactiveProfiles);
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    public List<MavenGoalExecutionResult> executeGoal(@NotNull String longRunningTaskId, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(14);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(15);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(16);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), this.myConsoleWrapper);
        List<MavenGoalExecutionResult> list = this.executeGoal(task, requests, goal);
        List<MavenGoalExecutionResult> list2 = list;
        if (list2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(17);
        }
        return list2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private List<MavenGoalExecutionResult> executeGoal(@NotNull LongRunningTask task, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal) {
        if (task == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(18);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(19);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(20);
        }
        try {
            ArrayList<MavenGoalExecutionResult> results = new ArrayList<MavenGoalExecutionResult>();
            for (MavenGoalExecutionRequest request : requests) {
                if (task.isCanceled()) break;
                MavenGoalExecutionResult result = this.doExecute(request, goal);
                results.add(result);
                task.incrementFinishedRequests();
            }
            return results;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private MavenGoalExecutionResult doExecute(@NotNull MavenGoalExecutionRequest request, @NotNull String goal) {
        if (request == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(21);
        }
        if (goal == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(22);
        }
        File file = request.file();
        MavenExplicitProfiles profiles = request.profiles();
        ArrayList<String> activeProfiles = new ArrayList<String>(profiles.getEnabledProfiles());
        ArrayList<String> inactiveProfiles = new ArrayList<String>(profiles.getDisabledProfiles());
        MavenExecutionRequest mavenExecutionRequest = this.createRequest(file, activeProfiles, inactiveProfiles);
        mavenExecutionRequest.setGoals(Collections.singletonList(goal));
        Maven maven = this.getComponent(Maven.class);
        MavenExecutionResult executionResult = maven.execute(mavenExecutionRequest);
        Maven40ExecutionResult result = new Maven40ExecutionResult(executionResult.getProject(), Maven40ServerEmbedderImpl.filterExceptions(executionResult.getExceptions()));
        return this.createEmbedderExecutionResult(file, result);
    }

    @NotNull
    private MavenGoalExecutionResult createEmbedderExecutionResult(@NotNull File file, Maven40ExecutionResult result) {
        if (file == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(23);
        }
        Collection problems = MavenProjectProblem.createProblemsList();
        this.collectProblems(file, result.getExceptions(), result.getModelProblems(), problems);
        MavenGoalExecutionResult.Folders folders = new MavenGoalExecutionResult.Folders();
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenGoalExecutionResult(false, file, folders, problems);
        }
        folders.setSources(mavenProject.getCompileSourceRoots());
        folders.setTestSources(mavenProject.getTestCompileSourceRoots());
        folders.setResources(Maven40ModelConverter.convertResources(mavenProject.getModel().getBuild().getResources()));
        folders.setTestResources(Maven40ModelConverter.convertResources(mavenProject.getModel().getBuild().getTestResources()));
        return new MavenGoalExecutionResult(true, file, folders, problems);
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            HashMap<String, FileModelSource> inputOptions = new HashMap<String, FileModelSource>();
            inputOptions.put("org.apache.maven.model.building.source", new FileModelSource(file));
            ModelReader reader = null;
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)"xml")) {
                try {
                    Object polyglotManager = this.myContainer.lookup("org.sonatype.maven.polyglot.PolyglotModelManager");
                    if (polyglotManager != null) {
                        Method getReaderFor = polyglotManager.getClass().getMethod("getReaderFor", Map.class);
                        reader = (ModelReader)getReaderFor.invoke(polyglotManager, inputOptions);
                    }
                }
                catch (ComponentLookupException polyglotManager) {
                }
                catch (Throwable e) {
                    MavenServerGlobals.getLogger().warn(e);
                }
            }
            if (reader == null) {
                try {
                    reader = (ModelReader)this.myContainer.lookup(ModelReader.class);
                }
                catch (ComponentLookupException e) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    Model model = reader.read(file, inputOptions);
                    return Maven40ModelConverter.convertModel(model);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().warn((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
        }
        return null;
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.myContainer.dispose();
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    public List<MavenArtifact> resolveArtifacts(@NotNull String longRunningTaskId, @NotNull Collection<MavenArtifactResolutionRequest> requests, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(24);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(25);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), this.myConsoleWrapper);
        List<MavenArtifact> list = this.doResolveArtifacts(task, requests);
        List<MavenArtifact> list2 = list;
        if (list2 == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(26);
        }
        return list2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    private List<MavenArtifact> doResolveArtifacts(@NotNull LongRunningTask task, @NotNull Collection<MavenArtifactResolutionRequest> requests) {
        ArrayList<MavenArtifact> arrayList;
        if (task == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(27);
        }
        if (requests == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(28);
        }
        try {
            ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
            for (MavenArtifactResolutionRequest request : requests) {
                if (task.isCanceled()) break;
                MavenArtifact artifact = this.doResolveArtifact(request.getArtifactInfo(), request.getRemoteRepositories());
                artifacts.add(artifact);
                task.incrementFinishedRequests();
            }
            arrayList = artifacts;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private MavenArtifact doResolveArtifact(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) {
        Artifact resolved = this.doResolveArtifact(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return Maven40ModelConverter.convertArtifact(resolved, this.getLocalRepositoryFile());
    }

    private Artifact doResolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories) {
        try {
            MavenExecutionRequest request = this.createRequest(null, null, null);
            for (ArtifactRepository artifactRepository : remoteRepositories) {
                request.addRemoteRepository(artifactRepository);
            }
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
            this.initLogging(this.myConsoleWrapper);
            RemoteRepositoryManager remoteRepositoryManager = this.getComponent(RemoteRepositoryManager.class);
            RepositorySystem repositorySystem = this.getComponent(RepositorySystem.class);
            List repositories = RepositoryUtils.toRepos(remoteRepositories);
            repositories = remoteRepositoryManager.aggregateRepositories(repositorySystemSession, new ArrayList(), repositories, false);
            ArtifactResult artifactResult = repositorySystem.resolveArtifact(repositorySystemSession, new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), repositories, null));
            return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact());
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return artifact;
        }
    }

    private void initLogging(Maven40ServerConsoleLogger consoleWrapper) {
        Maven40Sl4jLoggerWrapper.setCurrentWrapper(consoleWrapper);
    }

    @NotNull
    private List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) {
        List<ArtifactRepository> result = this.map2ArtifactRepositories(repositories);
        if (this.getComponent(LegacySupport.class).getRepositorySession() == null) {
            this.myRepositorySystem.injectMirror(result, this.myMavenSettings.getMirrors());
        }
        List<ArtifactRepository> list = result;
        if (list == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    private List<ArtifactRepository> map2ArtifactRepositories(List<MavenRemoteRepository> repositories) {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                result.add(this.buildArtifactRepository(Maven40ModelConverter.toNativeRepository(each)));
            }
            catch (InvalidRepositoryException e) {
                MavenServerGlobals.getLogger().warn((Throwable)e);
            }
        }
        return result;
    }

    private ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        MavenRepositorySystem repositorySystem = this.myRepositorySystem;
        RepositorySystemSession session = this.getComponent(LegacySupport.class).getRepositorySession();
        ArtifactRepository repository = MavenRepositorySystem.buildArtifactRepository((Repository)repo);
        if (session != null) {
            repositorySystem.injectMirror(session, Collections.singletonList(repository));
            repositorySystem.injectProxy(session, Collections.singletonList(repository));
            repositorySystem.injectAuthentication(session, Collections.singletonList(repository));
        }
        return repository;
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    public Set<MavenRemoteRepository> resolveRepositories(@NotNull Collection<MavenRemoteRepository> repositories, MavenToken token) {
        if (repositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(31);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return new HashSet<MavenRemoteRepository>(Maven40ModelConverter.convertRemoteRepositories(this.convertRepositories(new ArrayList<MavenRemoteRepository>(repositories))));
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    public MavenArtifactResolveResult resolveArtifactsTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) {
        MavenArtifactResolveResult mavenArtifactResolveResult;
        if (artifacts == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(32);
        }
        if (remoteRepositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(33);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            mavenArtifactResolveResult = this.resolveArtifactsTransitively(artifacts, remoteRepositories);
        }
        catch (Throwable e) {
            MavenProjectProblem problem;
            MavenServerGlobals.getLogger().error(e);
            Artifact transferArtifact = Maven40ServerEmbedderImpl.getProblemTransferArtifact(e);
            String message = Maven40ServerEmbedderImpl.getRootMessage(e);
            if (transferArtifact != null) {
                MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(transferArtifact, this.getLocalRepositoryFile());
                problem = MavenProjectProblem.createRepositoryProblem((String)"", (String)message, (boolean)true, (MavenArtifact)mavenArtifact);
            } else {
                problem = MavenProjectProblem.createStructureProblem((String)"", (String)message);
            }
            return new MavenArtifactResolveResult(Collections.emptyList(), problem);
        }
        if (mavenArtifactResolveResult == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(34);
        }
        return mavenArtifactResolveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenArtifactResolveResult resolveArtifactsTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) {
        if (artifacts == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(35);
        }
        if (remoteRepositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(36);
        }
        DefaultSessionFactory sessionFactory = this.getComponent(DefaultSessionFactory.class);
        MavenExecutionRequest request = this.createRequest(null, null, null);
        request.setRemoteRepositories(this.convertRepositories(remoteRepositories));
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        MavenSession mavenSession = this.createMavenSession(request, maven);
        Session session = sessionFactory.getSession(mavenSession);
        HashMap resolvedArtifactMap = new HashMap();
        SessionScope sessionScope = this.getComponent(SessionScope.class);
        try {
            sessionScope.enter();
            sessionScope.seed(DefaultSession.class, (Object)((DefaultSession)session));
            for (MavenArtifactInfo mavenArtifactInfo : artifacts) {
                ArtifactCoordinate coordinate = session.createArtifactCoordinate(mavenArtifactInfo.getGroupId(), mavenArtifactInfo.getArtifactId(), mavenArtifactInfo.getVersion(), mavenArtifactInfo.getClassifier(), mavenArtifactInfo.getPackaging(), null);
                ArtifactResolver artifactResolver = (ArtifactResolver)session.getService(ArtifactResolver.class);
                ArtifactResolverResult resolved = artifactResolver.resolve(session, Collections.singleton(coordinate));
                resolvedArtifactMap.putAll(resolved.getArtifacts());
                DependencyCoordinate dependencyCoordinate = session.createDependencyCoordinate(coordinate);
                Node dependencyNode = session.collectDependencies(dependencyCoordinate);
                List dependencyCoordinates = dependencyNode.stream().filter(node -> node != dependencyNode).filter(node -> node.getDependency() != null).map(node -> node.getDependency().toCoordinate()).collect(Collectors.toList());
                ArtifactResolverResult resolvedChildren = artifactResolver.resolve(session, dependencyCoordinates);
                resolvedArtifactMap.putAll(resolvedChildren.getArtifacts());
            }
        }
        finally {
            sessionScope.exit();
        }
        File localRepositoryFile = this.getLocalRepositoryFile();
        ArrayList<MavenArtifact> resolvedArtifacts = new ArrayList<MavenArtifact>();
        for (org.apache.maven.api.Artifact apiArtifact : resolvedArtifactMap.keySet()) {
            Path artifactPath = (Path)resolvedArtifactMap.get(apiArtifact);
            MavenArtifact mavenArtifact = Maven40ApiModelConverter.convertArtifactAndPath(apiArtifact, artifactPath, localRepositoryFile);
            resolvedArtifacts.add(mavenArtifact);
        }
        return new MavenArtifactResolveResult(resolvedArtifacts, null);
    }

    public Collection<MavenArchetype> getLocalArchetypes(MavenToken token, @NotNull String path) {
        if (path == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(37);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    public Collection<MavenArchetype> getRemoteArchetypes(MavenToken token, @NotNull String url) {
        if (url == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(38);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull List<MavenRemoteRepository> repositories, @Nullable String url, MavenToken token) {
        if (groupId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(39);
        }
        if (artifactId == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(40);
        }
        if (version == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(41);
        }
        if (repositories == null) {
            Maven40ServerEmbedderImpl.$$$reportNull$$$0(42);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    private void customizeComponents(@Nullable MavenWorkspaceMap workspaceMap) {
    }

    private void resetComponents() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/Maven40ServerEmbedderImpl";
                break;
            }
            case 1: 
            case 9: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTaskId";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginResolutionRequests";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 15: 
            case 19: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLineOptions";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/Maven40ServerEmbedderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleProjectDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "executeGoal";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveArtifacts";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRepositories";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactsTransitively";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "executeGoal";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedderExecutionResult";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifacts";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doResolveArtifacts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactsTransitively";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLocalArchetypes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginResolutionData {
        MavenId mavenPluginId;
        List<Dependency> pluginDependencies;
        List<RemoteRepository> remoteRepos;

        private PluginResolutionData(MavenId mavenPluginId, List<Dependency> pluginDependencies, List<RemoteRepository> remoteRepos) {
            this.mavenPluginId = mavenPluginId;
            this.pluginDependencies = pluginDependencies;
            this.remoteRepos = remoteRepos;
        }
    }
}

